/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.hbs;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.io.TemplateSource;
import java.util.Map;
import java.util.Objects;
import org.jooby.MediaType;
import org.jooby.Renderer;
import org.jooby.View;

public class HbsEngine
implements View.Engine {
    private Handlebars handlebars;
    private ValueResolver[] resolvers;

    public HbsEngine(Handlebars handlebars, ValueResolver[] resolvers) {
        this.handlebars = Objects.requireNonNull(handlebars, "Handlebars is required.");
        this.resolvers = Objects.requireNonNull(resolvers, "Resolvers are required.");
    }

    public void render(View view, Renderer.Context ctx) throws Exception {
        String vname = view.name();
        TemplateSource source = this.handlebars.getLoader().sourceAt(vname);
        Template template = this.handlebars.compile(source);
        Map locals = ctx.locals();
        locals.putIfAbsent("_vname", vname);
        locals.putIfAbsent("_vpath", source.filename());
        Context context = Context.newBuilder((Object)view.model()).combine(locals).resolver(this.resolvers).build();
        ctx.type(MediaType.html).send(template.apply(context));
    }

    public String toString() {
        return "hbs";
    }
}

