/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.hbs;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.cache.GuavaTemplateCache;
import com.github.jknack.handlebars.cache.NullTemplateCache;
import com.github.jknack.handlebars.cache.TemplateCache;
import com.github.jknack.handlebars.context.FieldValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import com.github.jknack.handlebars.context.MethodValueResolver;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.google.common.cache.CacheBuilder;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.function.Consumer;
import org.jooby.Body;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.View;
import org.jooby.hbs.ConfigValueResolver;
import org.jooby.hbs.LocalValueResolver;

public class Hbs
implements Jooby.Module {
    private final Handlebars hbs;

    public Hbs(Handlebars handlebars) {
        this.hbs = Objects.requireNonNull(handlebars, "A handlebars instance is required.");
    }

    public Hbs() {
        this(new Handlebars((TemplateLoader)new ClassPathTemplateLoader("/", ".html")));
    }

    public Hbs doWith(Consumer<Handlebars> block) {
        Objects.requireNonNull(block, "A hbs block is required.").accept(this.hbs);
        return this;
    }

    public void configure(Env mode, Config config, Binder binder) {
        if ("dev".equals(mode.name()) || config.getString("hbs.cache").isEmpty()) {
            this.hbs.with((TemplateCache)NullTemplateCache.INSTANCE);
        } else {
            this.hbs.with((TemplateCache)new GuavaTemplateCache(CacheBuilder.from((String)config.getString("hbs.cache")).build()));
        }
        binder.bind(Handlebars.class).toInstance((Object)this.hbs);
        Engine engine = new Engine(this.hbs);
        Multibinder.newSetBinder((Binder)binder, Body.Formatter.class).addBinding().toInstance((Object)engine);
        binder.bind(Key.get(View.Engine.class, (Annotation)Names.named((String)engine.name()))).toInstance((Object)engine);
    }

    public Config config() {
        return ConfigFactory.parseResources(this.getClass(), (String)"hbs.conf");
    }

    private static class Engine
    implements View.Engine {
        private Handlebars handlebars;

        public Engine(Handlebars handlebars) {
            this.handlebars = Objects.requireNonNull(handlebars, "A handlebars instance required.");
        }

        public String name() {
            return "hbs";
        }

        public void render(View view, Body.Writer writer) throws Exception {
            Template template = this.handlebars.compile(view.name());
            Object model = view.model();
            Context context = model instanceof Context ? (Context)model : Context.newBuilder((Object)model).combine(writer.locals()).resolver(new ValueResolver[]{MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, MethodValueResolver.INSTANCE, FieldValueResolver.INSTANCE, new LocalValueResolver(), new ConfigValueResolver()}).build();
            writer.text(out -> template.apply(context, out));
        }

        public String toString() {
            return this.name();
        }
    }
}

