/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.hbs;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.ValueResolver;
import java.util.Objects;
import org.jooby.BodyFormatter;
import org.jooby.View;

public class HbsEngine
implements View.Engine {
    private Handlebars handlebars;
    private ValueResolver[] resolvers;

    public HbsEngine(Handlebars handlebars, ValueResolver[] resolvers) {
        this.handlebars = Objects.requireNonNull(handlebars, "Handlebars is required.");
        this.resolvers = Objects.requireNonNull(resolvers, "Resolvers are required.");
    }

    public String name() {
        return "hbs";
    }

    public void render(View view, BodyFormatter.Context writer) throws Exception {
        Template template = this.handlebars.compile(view.name());
        Context context = Context.newBuilder((Object)view.model()).combine(writer.locals()).resolver(this.resolvers).build();
        writer.text(out -> template.apply(context, out));
    }

    public String toString() {
        return this.name();
    }
}

