/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.hbs;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.cache.GuavaTemplateCache;
import com.github.jknack.handlebars.cache.NullTemplateCache;
import com.github.jknack.handlebars.cache.TemplateCache;
import com.github.jknack.handlebars.context.FieldValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import com.github.jknack.handlebars.context.MethodValueResolver;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.google.common.cache.CacheBuilder;
import com.google.inject.Binder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValueFactory;
import java.lang.annotation.Annotation;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.Renderer;
import org.jooby.internal.hbs.ConfigValueResolver;
import org.jooby.internal.hbs.HbsEngine;
import org.jooby.internal.hbs.HbsHelpers;
import org.jooby.internal.hbs.RequestValueResolver;
import org.jooby.internal.hbs.SessionValueResolver;

public class Hbs
implements Jooby.Module {
    private final Handlebars hbs;
    private BiConsumer<Handlebars, Config> callback;
    private Set<Class<?>> helpers = new HashSet();
    private Deque<ValueResolver> resolvers = new LinkedList<ValueResolver>();

    public Hbs(String prefix, String suffix, Class<?> ... helpers) {
        this.hbs = new Handlebars((TemplateLoader)new ClassPathTemplateLoader(prefix, suffix));
        this.with(helpers);
        this.resolvers.add((ValueResolver)MapValueResolver.INSTANCE);
        this.resolvers.add(JavaBeanValueResolver.INSTANCE);
        this.resolvers.add(MethodValueResolver.INSTANCE);
        this.resolvers.add(new RequestValueResolver());
        this.resolvers.add(new SessionValueResolver());
        this.resolvers.add(new ConfigValueResolver());
        this.resolvers.add(FieldValueResolver.INSTANCE);
    }

    public Hbs(String prefix, Class<?> ... helpers) {
        this(prefix, ".html", helpers);
    }

    public Hbs(Class<?> ... helpers) {
        this("/", helpers);
    }

    public Hbs doWith(BiConsumer<Handlebars, Config> callback) {
        this.callback = Objects.requireNonNull(callback, "Configurer is required.");
        return this;
    }

    public Hbs doWith(Consumer<Handlebars> callback) {
        Objects.requireNonNull(callback, "Configurer is required.");
        return this.doWith((Handlebars hbs, Config conf) -> callback.accept((Handlebars)hbs));
    }

    public Hbs with(Class<?> ... helper) {
        for (Class<?> h : helper) {
            this.helpers.add(h);
        }
        return this;
    }

    public Hbs with(ValueResolver resolver) {
        Objects.requireNonNull(resolver, "Value resolver is required.");
        this.resolvers.addFirst(resolver);
        return this;
    }

    public void configure(Env env, Config config, Binder binder) {
        if ("dev".equals(env.name()) || config.getString("hbs.cache").isEmpty()) {
            this.hbs.with((TemplateCache)NullTemplateCache.INSTANCE);
        } else {
            this.hbs.with((TemplateCache)new GuavaTemplateCache(CacheBuilder.from((String)config.getString("hbs.cache")).build()));
        }
        if (this.callback != null) {
            this.callback.accept(this.hbs, config);
        }
        this.hbs.registerHelper("xss", (value, opts) -> {
            String[] xss = new String[opts.params.length];
            System.arraycopy(opts.params, 0, xss, 0, opts.params.length);
            return new Handlebars.SafeString((CharSequence)env.xss(xss).apply(value.toString()));
        });
        binder.bind(Handlebars.class).toInstance((Object)this.hbs);
        Multibinder helpersBinding = Multibinder.newSetBinder((Binder)binder, Object.class, (Annotation)Names.named((String)"hbs.helpers"));
        this.helpers.forEach(h -> helpersBinding.addBinding().to(h));
        HbsEngine engine = new HbsEngine(this.hbs, this.resolvers.toArray(new ValueResolver[this.resolvers.size()]));
        Multibinder.newSetBinder((Binder)binder, Renderer.class).addBinding().toInstance((Object)engine);
        binder.bind(HbsHelpers.class).asEagerSingleton();
    }

    public Config config() {
        return ConfigFactory.empty((String)Hbs.class.getName()).withValue("hbs.cache", ConfigValueFactory.fromAnyRef((Object)"maximumSize=100"));
    }
}

