/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.hbv;

import com.google.inject.Injector;
import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HbvConstraintValidatorFactory
implements ConstraintValidatorFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Injector injector;

    public HbvConstraintValidatorFactory(Injector injector) {
        this.injector = Objects.requireNonNull(injector, "Injector is required.");
    }

    public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> key) {
        return (T)((ConstraintValidator)this.injector.getInstance(key));
    }

    public void releaseInstance(ConstraintValidator<?, ?> instance) {
        if (instance instanceof Closeable) {
            try {
                ((Closeable)instance).close();
            }
            catch (IOException ex) {
                this.log.debug("Can't close constraint validator", (Throwable)ex);
            }
        }
    }
}

