/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.hbv;

import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.typesafe.config.Config;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.validation.Validation;
import javax.validation.Validator;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.Parser;
import org.jooby.hbv.HbvFactory;
import org.jooby.hbv.HbvParser;

public class Hbv
implements Jooby.Module {
    private Predicate<TypeLiteral<?>> predicate;
    private BiConsumer<HibernateValidatorConfiguration, Config> configurer;

    public Hbv(Predicate<TypeLiteral<?>> predicate) {
        this.predicate = Objects.requireNonNull(predicate, "Predicate is required.");
    }

    public Hbv(Class<?> ... classes) {
        this(Hbv.typeIs(classes));
    }

    public Hbv() {
        this(Hbv.none());
    }

    public Hbv doWith(Consumer<HibernateValidatorConfiguration> configurer) {
        Objects.requireNonNull(configurer, "Configurer callback is required.");
        this.configurer = (hvc, conf) -> configurer.accept((HibernateValidatorConfiguration)hvc);
        return this;
    }

    public Hbv doWith(BiConsumer<HibernateValidatorConfiguration, Config> configurer) {
        this.configurer = Objects.requireNonNull(configurer, "Configurer callback is required.");
        return this;
    }

    public void configure(Env env, Config config, Binder binder) {
        HibernateValidatorConfiguration configuration = (HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure();
        if (config.hasPath("hibernate.validator")) {
            config.getConfig("hibernate.validator").root().forEach((k, v) -> configuration.addProperty("hibernate.validator." + k, v.unwrapped().toString()));
        }
        if (this.configurer != null) {
            this.configurer.accept(configuration, config);
        }
        binder.bind(HibernateValidatorConfiguration.class).toInstance((Object)configuration);
        binder.bind(Validator.class).toProvider(HbvFactory.class).asEagerSingleton();
        env.lifeCycle(HbvFactory.class);
        Multibinder.newSetBinder((Binder)binder, Parser.class).addBinding().toInstance((Object)new HbvParser(this.predicate));
    }

    static Predicate<TypeLiteral<?>> typeIs(Class<?>[] classes) {
        return type -> {
            Class it = type.getRawType();
            for (Class klass : classes) {
                if (!it.isAssignableFrom(klass)) continue;
                return true;
            }
            return false;
        };
    }

    static Predicate<TypeLiteral<?>> none() {
        return type -> false;
    }
}

