/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.hbv;

import com.google.inject.Injector;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.jooby.hbv.HbvConstraintValidatorFactory;

class HbvFactory
implements Provider<Validator> {
    private final HibernateValidatorConfiguration conf;
    private Validator validator;
    private ValidatorFactory factory;

    @Inject
    public HbvFactory(HibernateValidatorConfiguration conf, Injector injector) {
        this.conf = Objects.requireNonNull(conf, "Validation config is required.");
        conf.constraintValidatorFactory((ConstraintValidatorFactory)new HbvConstraintValidatorFactory(injector));
    }

    public Validator get() {
        this.start();
        return this.validator;
    }

    @PostConstruct
    public void start() {
        if (this.factory == null) {
            this.factory = this.conf.buildValidatorFactory();
            this.validator = this.factory.getValidator();
        }
    }

    @PreDestroy
    public void stop() throws Exception {
        if (this.factory != null) {
            this.factory.close();
            this.validator = null;
            this.factory = null;
        }
    }
}

