/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.json;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import com.typesafe.config.Config;
import java.lang.annotation.Annotation;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.MediaType;
import org.jooby.Parser;
import org.jooby.Renderer;
import org.jooby.json.JacksonParser;
import org.jooby.json.JacksonRenderer;

public class Jackson
implements Jooby.Module {
    private final ObjectMapper mapper;
    private final Set<Module> modules = new LinkedHashSet<Module>();
    private MediaType type = MediaType.json;

    public Jackson(ObjectMapper mapper) {
        this.mapper = (ObjectMapper)Preconditions.checkNotNull((Object)mapper, (Object)"ObjectMapper is required.");
        this.modules.add((Module)new Jdk8Module());
        this.modules.add((Module)new JavaTimeModule());
    }

    public Jackson() {
        this(new ObjectMapper());
    }

    public Jackson type(MediaType type) {
        this.type = type;
        return this;
    }

    public Jackson types(String type) {
        return this.type(MediaType.valueOf((String)type));
    }

    public Jackson doWith(Consumer<ObjectMapper> block) {
        Objects.requireNonNull(block, "A json block is required.").accept(this.mapper);
        return this;
    }

    public void configure(Env mode, Config config, Binder binder) {
        Locale locale = Locale.forLanguageTag(config.getString("application.lang").replace("_", "-"));
        this.mapper.setDateFormat((DateFormat)new SimpleDateFormat(config.getString("application.dateFormat"), locale));
        this.mapper.setLocale(locale);
        this.mapper.setTimeZone(TimeZone.getTimeZone(config.getString("application.tz")));
        Multibinder moduleBinder = Multibinder.newSetBinder((Binder)binder, Module.class);
        this.modules.forEach(m -> moduleBinder.addBinding().toInstance(m));
        binder.bind(ObjectMapper.class).toInstance((Object)this.mapper);
        binder.bind(PostConfigurer.class).asEagerSingleton();
        JacksonParser parser = new JacksonParser(this.mapper, this.type);
        JacksonRenderer renderer = new JacksonRenderer(this.mapper, this.type);
        Multibinder.newSetBinder((Binder)binder, Renderer.class).addBinding().toInstance((Object)renderer);
        Multibinder.newSetBinder((Binder)binder, Parser.class).addBinding().toInstance((Object)parser);
        binder.bind(Key.get(Renderer.class, (Annotation)Names.named((String)renderer.toString()))).toInstance((Object)renderer);
        binder.bind(Key.get(Parser.class, (Annotation)Names.named((String)parser.toString()))).toInstance((Object)parser);
    }

    private static class PostConfigurer {
        @Inject
        public PostConfigurer(ObjectMapper mapper, Set<Module> jacksonModules) {
            mapper.registerModules(jacksonModules);
        }
    }
}

