/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.jackson;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JSR310Module;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.typesafe.config.Config;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.jooby.Body;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.MediaType;

public class Json
implements Jooby.Module {
    private final ObjectMapper mapper;
    private final Set<Module> modules = new LinkedHashSet<Module>();
    private List<MediaType> types = ImmutableList.of((Object)MediaType.json);

    public Json(ObjectMapper mapper) {
        this.mapper = (ObjectMapper)Preconditions.checkNotNull((Object)mapper, (Object)"An object mapper is required.");
        this.modules.add((Module)new Jdk8Module());
        this.modules.add((Module)new JSR310Module());
    }

    public Json() {
        this(new ObjectMapper());
    }

    public Json with(MediaType ... types) {
        this.types = ImmutableList.copyOf((Object[])types);
        return this;
    }

    public Json configure(Consumer<ObjectMapper> configurer) {
        Objects.requireNonNull(configurer, "A configurer is required.").accept(this.mapper);
        return this;
    }

    public void configure(Env mode, Config config, Binder binder) {
        Locale locale = Locale.forLanguageTag(config.getString("application.lang").replace("_", "-"));
        this.mapper.setDateFormat((DateFormat)new SimpleDateFormat(config.getString("application.dateFormat"), locale));
        this.mapper.setLocale(locale);
        this.mapper.setTimeZone(TimeZone.getTimeZone(config.getString("application.tz")));
        Multibinder moduleBinder = Multibinder.newSetBinder((Binder)binder, Module.class);
        this.modules.forEach(m -> moduleBinder.addBinding().toInstance(m));
        binder.bind(ObjectMapper.class).toInstance((Object)this.mapper);
        binder.bind(Configurer.class).asEagerSingleton();
        BodyHandler json = new BodyHandler(this.mapper, this.types);
        Multibinder.newSetBinder((Binder)binder, Body.Formatter.class).addBinding().toInstance((Object)json);
        Multibinder.newSetBinder((Binder)binder, Body.Parser.class).addBinding().toInstance((Object)json);
    }

    static class BodyHandler
    implements Body.Formatter,
    Body.Parser {
        private ObjectMapper mapper;
        private List<MediaType> types;

        public BodyHandler(ObjectMapper mapper, List<MediaType> types) {
            this.mapper = (ObjectMapper)Preconditions.checkNotNull((Object)mapper, (Object)"An object mapper is required.");
            this.types = Objects.requireNonNull(types, "The types is required.");
        }

        public List<MediaType> types() {
            return this.types;
        }

        public boolean canParse(TypeLiteral<?> type) {
            return this.mapper.canDeserialize(this.mapper.constructType(type.getType()));
        }

        public boolean canFormat(Class<?> type) {
            return this.mapper.canSerialize(type);
        }

        public <T> T parse(TypeLiteral<T> type, Body.Reader reader) throws Exception {
            return (T)reader.text(in -> this.mapper.readValue(in, this.mapper.constructType(type.getType())));
        }

        public void format(Object body, Body.Writer writer) throws Exception {
            writer.text(out -> this.mapper.writeValue(out, body));
        }

        public String toString() {
            return "json";
        }
    }

    static class Configurer {
        @Inject
        public Configurer(ObjectMapper mapper, Set<Module> jacksonModules) {
            mapper.registerModules(jacksonModules);
        }
    }
}

