/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.jooby.MediaType;
import org.jooby.Renderer;

abstract class JacksonBaseRenderer
implements Renderer {
    protected final ObjectMapper mapper;
    protected final MediaType type;

    public JacksonBaseRenderer(ObjectMapper mapper, MediaType type) {
        this.mapper = mapper;
        this.type = type;
    }

    public void render(Object value, Renderer.Context ctx) throws Exception {
        if (ctx.accepts(this.type) && this.mapper.canSerialize(value.getClass())) {
            ctx.type(this.type);
            this.renderValue(value, ctx);
        }
    }

    protected abstract void renderValue(Object var1, Renderer.Context var2) throws Exception;

    public String name() {
        return "json";
    }

    public String toString() {
        return this.name();
    }
}

