/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.jooby.MediaType;
import org.jooby.Renderer;
import org.jooby.json.JacksonView;

class JacksonRenderer
implements Renderer {
    protected final ObjectMapper mapper;
    protected final MediaType type;

    public JacksonRenderer(ObjectMapper mapper, MediaType type) {
        this.mapper = mapper;
        this.type = type;
    }

    public void render(Object value, Renderer.Context ctx) throws Exception {
        if (ctx.accepts(this.type) && this.mapper.canSerialize(value.getClass())) {
            ctx.type(this.type);
            this.renderValue(value, ctx);
        }
    }

    protected void renderValue(Object value, Renderer.Context ctx) throws Exception {
        byte[] bytes;
        if (value instanceof JacksonView) {
            JacksonView viewResponse = (JacksonView)value;
            bytes = this.mapper.writerWithView(viewResponse.view).writeValueAsBytes(viewResponse.data);
        } else {
            bytes = this.mapper.writeValueAsBytes(value);
        }
        ctx.length((long)bytes.length).send(bytes);
    }

    public String name() {
        return "json";
    }

    public String toString() {
        return this.name();
    }
}

