/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.jdbi;

import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.typesafe.config.Config;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.sql.DataSource;
import org.jooby.Env;
import org.jooby.jdbc.Jdbc;
import org.jooby.jdbi.OptionalArgumentFactory;
import org.jooby.jdbi.OptionalContainerFactory;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.logging.SLF4JLog;
import org.skife.jdbi.v2.tweak.ArgumentFactory;
import org.skife.jdbi.v2.tweak.ContainerFactory;
import org.skife.jdbi.v2.tweak.SQLLog;

public class Jdbi
extends Jdbc {
    private BiConsumer<DBI, Config> configurer;
    private List<Class<?>> sqlObjects;

    public Jdbi(Class<?> ... sqlObjects) {
        this("db", sqlObjects);
    }

    public Jdbi(String db, Class<?> ... sqlObjects) {
        super(db);
        this.sqlObjects = Lists.newArrayList((Object[])sqlObjects);
    }

    public Jdbi doWith(BiConsumer<DBI, Config> configurer) {
        this.configurer = Objects.requireNonNull(configurer, "Configurer is required.");
        return this;
    }

    public void configure(Env env, Config config, Binder binder) {
        super.configure(env, config, binder);
        DBI dbi = new DBI(() -> ((DataSource)this.dataSource().get()).getConnection());
        dbi.setSQLLog((SQLLog)new SLF4JLog());
        dbi.registerArgumentFactory((ArgumentFactory)new OptionalArgumentFactory());
        dbi.registerContainerFactory((ContainerFactory)new OptionalContainerFactory());
        this.keys(DBI.class, key -> binder.bind(key).toInstance((Object)dbi));
        this.keys(Handle.class, key -> binder.bind(key).toProvider(() -> dbi.open()));
        this.sqlObjects.forEach(sqlObject -> binder.bind(sqlObject).toProvider(() -> dbi.open(sqlObject)));
        if (this.configurer != null) {
            this.configurer.accept(dbi, config);
        }
    }
}

