/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import com.google.common.base.Strings;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.skife.jdbi.org.antlr.runtime.ANTLRStringStream;
import org.skife.jdbi.org.antlr.runtime.CharStream;
import org.skife.jdbi.org.antlr.runtime.Token;
import org.skife.jdbi.rewriter.colon.ColonStatementLexer;
import org.skife.jdbi.v2.Binding;
import org.skife.jdbi.v2.IterableArgument;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.exceptions.UnableToCreateStatementException;
import org.skife.jdbi.v2.exceptions.UnableToExecuteStatementException;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.RewrittenStatement;
import org.skife.jdbi.v2.tweak.StatementRewriter;

public class ExpandedStmtRewriter
implements StatementRewriter {
    public RewrittenStatement rewrite(String sql, Binding params, StatementContext ctx) {
        ParsedStatement stmt = new ParsedStatement();
        try {
            String parsedSql = this.parseString(sql, stmt, params);
            return new MyRewrittenStatement(parsedSql, stmt, ctx);
        }
        catch (IllegalArgumentException e) {
            throw new UnableToCreateStatementException("Exception parsing for named parameter replacement", (Throwable)e, ctx);
        }
    }

    String parseString(String sql, ParsedStatement stmt, Binding params) throws IllegalArgumentException {
        StringBuilder b = new StringBuilder();
        ColonStatementLexer lexer = new ColonStatementLexer((CharStream)new ANTLRStringStream(sql));
        Token t = lexer.nextToken();
        int pos = 0;
        while (t.getType() != -1) {
            switch (t.getType()) {
                case 8: {
                    b.append(t.getText());
                    break;
                }
                case 9: {
                    String pname = t.getText().substring(1, t.getText().length());
                    stmt.addNamedParamAt(pname);
                    Argument arg = params.forName(pname);
                    if (arg instanceof IterableArgument) {
                        int size = ((IterableArgument)arg).size();
                        b.append(Strings.repeat((String)"?, ", (int)size));
                        b.setLength(b.length() - 2);
                        break;
                    }
                    b.append("?");
                    break;
                }
                case 11: {
                    b.append(t.getText());
                    break;
                }
                case 5: {
                    b.append(t.getText());
                    break;
                }
                case 10: {
                    Argument posarg = params.forPosition(pos);
                    if (posarg instanceof IterableArgument) {
                        int size = ((IterableArgument)posarg).size();
                        b.append(Strings.repeat((String)"?, ", (int)size));
                        b.setLength(b.length() - 2);
                        pos += size;
                    } else {
                        b.append("?");
                        ++pos;
                    }
                    stmt.addPositionalParamAt();
                    break;
                }
                case 6: {
                    b.append(t.getText().substring(1));
                    break;
                }
            }
            t = lexer.nextToken();
        }
        return b.toString();
    }

    static class ParsedStatement {
        private boolean positionalOnly = true;
        private List<String> params = new ArrayList<String>();

        ParsedStatement() {
        }

        public void addNamedParamAt(String name) {
            this.positionalOnly = false;
            this.params.add(name);
        }

        public void addPositionalParamAt() {
            this.params.add("*");
        }
    }

    private static class MyRewrittenStatement
    implements RewrittenStatement {
        private final String sql;
        private final ParsedStatement stmt;
        private final StatementContext context;

        public MyRewrittenStatement(String sql, ParsedStatement stmt, StatementContext ctx) {
            this.context = ctx;
            this.sql = sql;
            this.stmt = stmt;
        }

        public void bind(Binding params, PreparedStatement statement) throws SQLException {
            if (this.stmt.positionalOnly) {
                boolean finished = false;
                int i = 0;
                while (!finished) {
                    Argument a = params.forPosition(i);
                    if (a != null) {
                        try {
                            a.apply(i + 1, statement, this.context);
                            Integer pos = (Integer)this.context.getAttribute("position");
                            i += Optional.ofNullable(pos).orElse(1).intValue();
                            this.context.setAttribute("position", null);
                            continue;
                        }
                        catch (SQLException e) {
                            throw new UnableToExecuteStatementException(String.format("Exception while binding positional param at (0 based) position %d", i), (Throwable)e, this.context);
                        }
                    }
                    finished = true;
                }
            } else {
                int i = 0;
                for (String named_param : this.stmt.params) {
                    if ("*".equals(named_param)) continue;
                    Argument a = params.forName(named_param);
                    if (a == null) {
                        a = params.forPosition(i);
                    }
                    if (a == null) {
                        String msg = String.format("Unable to execute, no named parameter matches \"%s\" and no positional param for place %d (which is %d in the JDBC 'start at 1' scheme) has been set.", named_param, i, i + 1);
                        throw new UnableToExecuteStatementException(msg, this.context);
                    }
                    try {
                        a.apply(i + 1, statement, this.context);
                    }
                    catch (SQLException e) {
                        throw new UnableToCreateStatementException(String.format("Exception while binding '%s'", named_param), (Throwable)e, this.context);
                    }
                    ++i;
                }
            }
        }

        public String getSql() {
            return this.sql;
        }
    }
}

