/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.jdbi;

import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.typesafe.config.Config;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.sql.DataSource;
import org.jooby.Env;
import org.jooby.jdbc.Jdbc;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.DBI2;
import org.skife.jdbi.v2.ExpandedStmtRewriter;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IterableArgumentFactory;
import org.skife.jdbi.v2.OptionalArgumentFactory;
import org.skife.jdbi.v2.OptionalContainerFactory;
import org.skife.jdbi.v2.logging.SLF4JLog;
import org.skife.jdbi.v2.tweak.SQLLog;

public class Jdbi
extends Jdbc {
    private BiConsumer<DBI, Config> configurer;
    private List<Class<?>> sqlObjects;

    public Jdbi(Class<?> ... sqlObjects) {
        this("db", sqlObjects);
    }

    public Jdbi(String db, Class<?> ... sqlObjects) {
        super(db);
        this.sqlObjects = Lists.newArrayList((Object[])sqlObjects);
    }

    public Jdbi doWith(BiConsumer<DBI, Config> configurer) {
        this.configurer = Objects.requireNonNull(configurer, "Configurer is required.");
        return this;
    }

    public void configure(Env env, Config config, Binder binder) {
        super.configure(env, config, binder);
        DBI2 dbi = new DBI2(() -> ((DataSource)this.dataSource().get()).getConnection());
        dbi.setSQLLog((SQLLog)new SLF4JLog());
        dbi.registerArgumentFactory(new OptionalArgumentFactory());
        dbi.registerArgumentFactory(new IterableArgumentFactory());
        dbi.registerContainerFactory(new OptionalContainerFactory());
        dbi.setStatementRewriter(new ExpandedStmtRewriter());
        this.keys(DBI.class, key -> binder.bind(key).toInstance((Object)dbi));
        this.keys(Handle.class, key -> binder.bind(key).toProvider(() -> dbi.open()));
        this.sqlObjects.forEach(sqlObject -> binder.bind(sqlObject).toProvider(() -> dbi.open((Class)sqlObject)));
        if (this.configurer != null) {
            this.configurer.accept(dbi, config);
        }
    }
}

