/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.util.Optional;
import org.skife.jdbi.v2.ContainerBuilder;
import org.skife.jdbi.v2.tweak.ContainerFactory;

public class OptionalContainerFactory
implements ContainerFactory<Optional<?>> {
    public boolean accepts(Class<?> type) {
        return Optional.class.isAssignableFrom(type);
    }

    public ContainerBuilder<Optional<?>> newContainerBuilderFor(Class<?> type) {
        return OptionalContainerFactory.optional();
    }

    private static ContainerBuilder<Optional<?>> optional() {
        return new ContainerBuilder<Optional<?>>(){
            private Optional<?> value = Optional.empty();

            public Optional<?> build() {
                return this.value;
            }

            public ContainerBuilder<Optional<?>> add(Object it) {
                this.value = Optional.ofNullable(it);
                return this;
            }
        };
    }
}

