/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.skife.jdbi.v2.Foreman;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;

public class IterableArgument
implements Argument {
    private Iterable<?> values;
    private Foreman foreman;

    public IterableArgument(Object value, StatementContext ctx) {
        if (value.getClass().isArray()) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < Array.getLength(value); ++i) {
                builder.add(Array.get(value, i));
            }
            this.values = builder.build();
        } else {
            this.values = (Iterable)value;
        }
        this.foreman = new Foreman();
        List factories = (List)ctx.getAttribute("__argumentFactories_");
        factories.forEach(arg_0 -> ((Foreman)this.foreman).register(arg_0));
    }

    public void apply(int position, PreparedStatement stmt, StatementContext ctx) throws SQLException {
        int i = position;
        for (Object value : this.values) {
            this.foreman.waffle(value.getClass(), value, ctx).apply(i, stmt, ctx);
            ++i;
        }
        ctx.setAttribute("position", (Object)i);
    }

    public int size() {
        return Iterables.size(this.values);
    }
}

