/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.jdbi;

import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.List;
import org.jooby.Env;
import org.jooby.jdbc.Jdbc;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.ExpandedStmtRewriter;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IterableArgumentFactory;
import org.skife.jdbi.v2.OptionalArgumentFactory;
import org.skife.jdbi.v2.OptionalContainerFactory;
import org.skife.jdbi.v2.logging.SLF4JLog;
import org.skife.jdbi.v2.tweak.ArgumentFactory;
import org.skife.jdbi.v2.tweak.ConnectionFactory;
import org.skife.jdbi.v2.tweak.SQLLog;

public class Jdbi
extends Jdbc {
    public static final String ARG_FACTORIES = "__argumentFactories_";
    private List<Class<?>> sqlObjects;

    public Jdbi(Class<?> ... sqlObjects) {
        this("db", sqlObjects);
    }

    public Jdbi(String db, Class<?> ... sqlObjects) {
        super(db);
        this.sqlObjects = Lists.newArrayList((Object[])sqlObjects);
    }

    public void configure(Env env, Config config, Binder binder) {
        this.configure(env, config, binder, (name, ds) -> {
            DBI2 dbi = new DBI2(() -> ds.getConnection());
            dbi.setSQLLog((SQLLog)new SLF4JLog());
            dbi.registerArgumentFactory(new OptionalArgumentFactory());
            dbi.registerArgumentFactory(new IterableArgumentFactory());
            dbi.registerContainerFactory(new OptionalContainerFactory());
            dbi.setStatementRewriter(new ExpandedStmtRewriter());
            Env.ServiceKey serviceKey = env.serviceKey();
            serviceKey.generate(DBI.class, name, k -> binder.bind(k).toInstance((Object)dbi));
            serviceKey.generate(Handle.class, name, k -> binder.bind(k).toProvider(() -> dbi.open()));
            this.sqlObjects.forEach(sqlObject -> binder.bind(sqlObject).toProvider(() -> dbi.open((Class)sqlObject)));
            this.callback((Object)dbi, config);
        });
    }

    static class DBI2
    extends DBI {
        private List<ArgumentFactory<?>> factories = new ArrayList();

        public DBI2(ConnectionFactory connectionFactory) {
            super(connectionFactory);
            this.define(Jdbi.ARG_FACTORIES, this.factories);
        }

        public void registerArgumentFactory(ArgumentFactory<?> argumentFactory) {
            this.factories.add(argumentFactory);
            super.registerArgumentFactory(argumentFactory);
        }
    }
}

