/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.jdbi;

import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.name.Names;
import com.typesafe.config.Config;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.jooby.Env;
import org.jooby.Jooby;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.ExpandedStmtRewriter;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IterableArgumentFactory;
import org.skife.jdbi.v2.OptionalArgumentFactory;
import org.skife.jdbi.v2.OptionalContainerFactory;
import org.skife.jdbi.v2.logging.SLF4JLog;
import org.skife.jdbi.v2.tweak.ArgumentFactory;
import org.skife.jdbi.v2.tweak.SQLLog;

public class Jdbi
implements Jooby.Module {
    public static final String ARG_FACTORIES = "__argumentFactories_";
    private final String name;
    private List<Class<?>> sqlObjects;
    private BiConsumer<DBI, Config> callback;

    public Jdbi(Class<?> ... sqlObjects) {
        this("db", sqlObjects);
    }

    public Jdbi(String db, Class<?> ... sqlObjects) {
        this.name = db;
        this.sqlObjects = Lists.newArrayList((Object[])sqlObjects);
    }

    public void configure(Env env, Config config, Binder binder) {
        Key dskey = Key.get(DataSource.class, (Annotation)Names.named((String)this.name));
        DataSource ds = (DataSource)env.get(dskey).orElseThrow(() -> new NoSuchElementException("DataSource missing: " + dskey));
        DBI2 dbi = new DBI2(ds);
        dbi.setSQLLog((SQLLog)new SLF4JLog());
        dbi.registerArgumentFactory(new OptionalArgumentFactory());
        dbi.registerArgumentFactory(new IterableArgumentFactory());
        dbi.registerContainerFactory(new OptionalContainerFactory());
        dbi.setStatementRewriter(new ExpandedStmtRewriter());
        Env.ServiceKey serviceKey = env.serviceKey();
        serviceKey.generate(DBI.class, this.name, k -> binder.bind(k).toInstance((Object)dbi));
        serviceKey.generate(Handle.class, this.name, k -> binder.bind(k).toProvider(() -> dbi.open()));
        this.sqlObjects.forEach(sqlObject -> binder.bind(sqlObject).toProvider(() -> dbi.open((Class)sqlObject)));
        if (this.callback != null) {
            this.callback.accept(dbi, config);
        }
    }

    public Jdbi doWith(BiConsumer<DBI, Config> configurer) {
        this.callback = configurer;
        return this;
    }

    public Jdbi doWith(Consumer<DBI> configurer) {
        return this.doWith((DBI dbi, Config conf) -> configurer.accept((DBI)dbi));
    }

    static class DBI2
    extends DBI {
        private List<ArgumentFactory<?>> factories = new ArrayList();

        public DBI2(DataSource ds) {
            super(ds);
            this.define(Jdbi.ARG_FACTORIES, this.factories);
        }

        public void registerArgumentFactory(ArgumentFactory<?> argumentFactory) {
            this.factories.add(argumentFactory);
            super.registerArgumentFactory(argumentFactory);
        }
    }
}

