/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.jdbi;

import java.util.Optional;
import org.jdbi.v3.core.Handle;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.funzy.Try;
import org.jooby.jdbi.TransactionalRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CloseHandle
implements Route.Complete {
    private final Logger logger = LoggerFactory.getLogger(TransactionalRequest.class);
    private final Handle handle;

    public CloseHandle(Handle handle) {
        this.handle = handle;
    }

    public void handle(Request req, Response rsp, Optional<Throwable> cause) {
        if (this.handle.isClosed()) {
            this.logger.warn("closed handle: {}", (Object)this.handle);
        } else {
            this.logger.debug("closing handling: {}", (Object)this.handle);
            Try.of((AutoCloseable)this.handle).run(h -> {
                if (h.isInTransaction()) {
                    if (cause.isPresent()) {
                        this.logger.debug("rollback transaction: {}", (Object)this.handle, cause.get());
                        h.rollback();
                    } else {
                        this.logger.debug("commit transaction {}", (Object)this.handle);
                        h.commit();
                    }
                }
            }).throwException();
        }
    }
}

