/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.jdbi;

import java.util.Optional;
import org.jdbi.v3.core.Handle;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.jdbi.TransactionalRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RollbackTransaction
implements Route.Complete {
    private final Logger logger = LoggerFactory.getLogger(TransactionalRequest.class);
    private final Handle handle;

    RollbackTransaction(Handle handle) {
        this.handle = handle;
    }

    public void handle(Request req, Response rsp, Optional<Throwable> cause) {
        cause.ifPresent(x -> {
            if (this.handle.isInTransaction()) {
                this.logger.debug("rollback transaction: {} ", (Object)this.handle, x);
                this.handle.rollback();
            } else {
                this.logger.warn("unable to rollback inactive transaction: {}", (Object)this.handle);
            }
        });
    }
}

