/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.jdbi;

import java.util.Optional;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.jdbi.CloseHandle;
import org.jooby.jdbi.CommitTransaction;
import org.jooby.jdbi.RollbackTransaction;
import org.jooby.jdbi.TransactionalRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OpenHandle
implements Route.Filter {
    private Logger logger = LoggerFactory.getLogger(TransactionalRequest.class);
    private final Jdbi jdbi;
    private final TransactionalRequest trx;

    OpenHandle(Jdbi jdbi, TransactionalRequest trx) {
        this.jdbi = jdbi;
        this.trx = trx;
    }

    public void handle(Request req, Response rsp, Route.Chain chain) throws Throwable {
        this.logger.debug("open handle");
        Handle handle = this.jdbi.open();
        Optional.ofNullable(this.trx.configurer).ifPresent(c -> c.accept(handle));
        req.set(this.trx.handle(), (Object)handle);
        this.logger.debug("new transaction: {}", (Object)handle);
        handle.begin();
        rsp.after((Route.After)new CommitTransaction(handle));
        rsp.complete((Route.Complete)new RollbackTransaction(handle));
        rsp.complete((Route.Complete)new CloseHandle(handle));
        chain.next(req, rsp);
    }
}

