/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.jdbi;

import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jdbi.v3.core.Handle;

public class TransactionalRequest {
    private String method = "*";
    private String pattern = "*";
    private Key<Handle> handleKey = Key.get(Handle.class);
    private List<Class> sqlObjects = new ArrayList<Class>();
    Consumer<Handle> configurer;

    public TransactionalRequest doWith(Consumer<Handle> configurer) {
        this.configurer = Objects.requireNonNull(configurer, "Handle configurer required.");
        return this;
    }

    public String method() {
        return this.method;
    }

    public TransactionalRequest method(String method) {
        this.method = method;
        return this;
    }

    public String pattern() {
        return this.pattern;
    }

    public TransactionalRequest pattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public Key<Handle> handle() {
        return this.handleKey;
    }

    public TransactionalRequest handle(String name) {
        this.handleKey = Key.get(Handle.class, (Annotation)Names.named((String)name));
        return this;
    }

    public List<Class> sqlObjects() {
        return this.sqlObjects;
    }

    public TransactionalRequest attach(Class sqlObject) {
        this.sqlObjects.add(sqlObject);
        return this;
    }
}

