/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.jdbi;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.name.Names;
import com.typesafe.config.Config;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.Registry;
import org.jooby.Route;
import org.jooby.jdbi.OpenHandle;
import org.jooby.jdbi.TransactionalRequest;
import org.jooby.scope.Providers;
import org.jooby.scope.RequestScoped;

public class Jdbi3
implements Jooby.Module {
    private String name;
    private BiConsumer<Jdbi, Config> callback;
    private List<TransactionalRequest> trx = new ArrayList<TransactionalRequest>();

    public Jdbi3(String name) {
        this.name = Objects.requireNonNull(name, "Jdbi name required.");
    }

    public Jdbi3() {
        this("db");
    }

    public Jdbi3 doWith(BiConsumer<Jdbi, Config> configurer) {
        this.callback = configurer;
        return this;
    }

    public Jdbi3 doWith(Consumer<Jdbi> configurer) {
        return this.doWith((Jdbi jdbi, Config conf) -> configurer.accept((Jdbi)jdbi));
    }

    public Jdbi3 transactionPerRequest() {
        return this.transactionPerRequest(new TransactionalRequest());
    }

    public Jdbi3 transactionPerRequest(TransactionalRequest request) {
        this.trx.add(request);
        return this;
    }

    public void configure(Env env, Config conf, Binder binder) throws Throwable {
        Key dskey = Key.get(DataSource.class, (Annotation)Names.named((String)this.name));
        DataSource dataSource = (DataSource)env.get(dskey).orElseThrow(() -> new NoSuchElementException("DataSource missing: " + dskey));
        Jdbi jdbi = Jdbi.create((DataSource)dataSource);
        if (this.callback != null) {
            this.callback.accept(jdbi, conf);
        }
        env.serviceKey().generate(Jdbi.class, this.name, key -> binder.bind(key).toInstance((Object)jdbi));
        this.trx.forEach(it -> {
            Key<Handle> key = it.handle();
            binder.bind(key).toProvider(Providers.outOfScope(key)).in(RequestScoped.class);
            AtomicReference registry = new AtomicReference();
            env.onStart(registry::set);
            it.sqlObjects().forEach(sqlObject -> binder.bind(sqlObject).toProvider(() -> {
                Handle handle = (Handle)((Registry)registry.get()).require(key);
                return handle.attach(sqlObject);
            }));
            env.router().use(it.method(), it.pattern(), (Route.Filter)new OpenHandle(jdbi, (TransactionalRequest)it)).name("transactionPerRequest");
        });
    }
}

