/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.jedis;

import com.google.inject.Binder;
import com.google.inject.name.Names;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.inject.Provider;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.jedis.RedisProvider;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class Redis
implements Jooby.Module {
    private String name;
    private boolean named;

    public Redis(String name) {
        this.name = Objects.requireNonNull(name, "A db property is required.");
        this.named = !"db".equals(name);
    }

    public Redis() {
        this("db");
    }

    public Redis named() {
        this.named = true;
        return this;
    }

    public Redis unnamed() {
        this.named = false;
        return this;
    }

    public void configure(Env env, Config config, Binder binder) {
        GenericObjectPoolConfig poolConfig = this.poolConfig(config, this.name);
        int timeout = (int)config.getDuration("jedis.timeout", TimeUnit.MILLISECONDS);
        URI uri = URI.create(config.getString(this.name));
        JedisPool pool = new JedisPool(poolConfig, uri, timeout);
        RedisProvider managed = new RedisProvider(pool, uri, poolConfig);
        Provider jedis = () -> pool.getResource();
        if (this.named) {
            binder.bind(JedisPool.class).annotatedWith((Annotation)Names.named((String)this.name)).toProvider((Provider)managed).asEagerSingleton();
            binder.bind(Jedis.class).annotatedWith((Annotation)Names.named((String)this.name)).toProvider(jedis);
        } else {
            binder.bind(JedisPool.class).toProvider((Provider)managed).asEagerSingleton();
            binder.bind(Jedis.class).toProvider(jedis);
        }
    }

    private GenericObjectPoolConfig poolConfig(Config config, String name) {
        Config poolConfig = config.getConfig("jedis.pool");
        String override = "jedis." + name;
        if (config.hasPath(override)) {
            poolConfig = config.getConfig(override).withFallback((ConfigMergeable)poolConfig);
        }
        return this.poolConfig(poolConfig);
    }

    private GenericObjectPoolConfig poolConfig(Config config) {
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setBlockWhenExhausted(config.getBoolean("blockWhenExhausted"));
        poolConfig.setEvictionPolicyClassName(config.getString("evictionPolicyClassName"));
        poolConfig.setJmxEnabled(config.getBoolean("jmxEnabled"));
        poolConfig.setJmxNamePrefix(config.getString("jmxNamePrefix"));
        poolConfig.setLifo(config.getBoolean("lifo"));
        poolConfig.setMaxIdle(config.getInt("maxIdle"));
        poolConfig.setMaxTotal(config.getInt("maxTotal"));
        poolConfig.setMaxWaitMillis(config.getDuration("maxWait", TimeUnit.MILLISECONDS));
        poolConfig.setMinEvictableIdleTimeMillis(config.getDuration("minEvictableIdle", TimeUnit.MILLISECONDS));
        poolConfig.setMinIdle(config.getInt("minIdle"));
        poolConfig.setNumTestsPerEvictionRun(config.getInt("numTestsPerEvictionRun"));
        poolConfig.setSoftMinEvictableIdleTimeMillis(config.getDuration("softMinEvictableIdle", TimeUnit.MILLISECONDS));
        poolConfig.setTestOnBorrow(config.getBoolean("testOnBorrow"));
        poolConfig.setTestOnReturn(config.getBoolean("testOnReturn"));
        poolConfig.setTestWhileIdle(config.getBoolean("testWhileIdle"));
        poolConfig.setTimeBetweenEvictionRunsMillis(config.getDuration("timeBetweenEvictionRuns", TimeUnit.MILLISECONDS));
        return poolConfig;
    }

    public Config config() {
        return ConfigFactory.parseResources(this.getClass(), (String)"jedis.conf");
    }
}

