/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.jedis;

import com.google.inject.Binder;
import com.typesafe.config.Config;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.jooby.Env;
import org.jooby.jedis.Redis;
import org.jooby.jedis.RedisProvider;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.util.Pool;

public class RedisSentinel
extends Redis {
    @Override
    public void configure(Env env, Config config, Binder binder) {
        GenericObjectPoolConfig poolConfig = this.poolConfig(config.getConfig("jedis.pool"));
        int timeout = (int)config.getDuration("jedis.timeout", TimeUnit.MILLISECONDS);
        List hosts = config.getStringList("jedis.sentinel.hosts");
        if (hosts.size() < 1) {
            throw new IllegalArgumentException("List of hosts (jedis.sentinel.hosts) can not be empty");
        }
        HashSet sentinels = new HashSet(hosts);
        String MASTER_NAME = config.getString("jedis.sentinel.master");
        String REDIS_PASSWORD = config.getString("jedis.password");
        JedisSentinelPool pool = REDIS_PASSWORD.length() > 0 ? new JedisSentinelPool(MASTER_NAME, sentinels, poolConfig, timeout, REDIS_PASSWORD) : new JedisSentinelPool(MASTER_NAME, sentinels, poolConfig, timeout);
        RedisProvider provider = new RedisProvider((Pool)pool, null, poolConfig);
        env.onStart(provider::start);
        env.onStop(provider::stop);
        Env.ServiceKey serviceKey = env.serviceKey();
        serviceKey.generate(JedisSentinelPool.class, "db", k -> binder.bind(k).toInstance((Object)pool));
    }
}

