/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.jedis;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValueFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jooby.Session;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Singleton
public class RedisSessionStore
implements Session.Store {
    private JedisPool pool;
    private int timeout;
    private String prefix;

    public RedisSessionStore(JedisPool pool, String prefix, int timeout) {
        this.pool = Objects.requireNonNull(pool, "Jedis pool is required.");
        this.timeout = timeout;
        this.prefix = Objects.requireNonNull(prefix, "Prefix is required.");
    }

    @Inject
    public RedisSessionStore(JedisPool pool, @Named(value="jedis.session.prefix") String prefix, @Named(value="jedis.session.timeout") String timeout) {
        this(pool, prefix, RedisSessionStore.seconds(timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session get(Session.Builder builder) {
        try (Jedis jedis = null;){
            jedis = this.pool.getResource();
            String key = this.key(builder.sessionId());
            Map attrs = jedis.hgetAll(key);
            if (attrs == null || attrs.size() == 0) {
                Session session = null;
                return session;
            }
            if (this.timeout > 0) {
                jedis.expire(key, this.timeout);
            }
            Session session = builder.accessedAt(Long.parseLong((String)attrs.remove("_accessedAt"))).createdAt(Long.parseLong((String)attrs.remove("_createdAt"))).savedAt(Long.parseLong((String)attrs.remove("_savedAt"))).set(attrs).build();
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Session session) {
        try (Jedis jedis = null;){
            jedis = this.pool.getResource();
            String key = this.key(session);
            HashMap<String, String> attrs = new HashMap<String, String>(session.attributes());
            attrs.put("_createdAt", Long.toString(session.createdAt()));
            attrs.put("_accessedAt", Long.toString(session.accessedAt()));
            attrs.put("_savedAt", Long.toString(session.savedAt()));
            jedis.hmset(key, attrs);
            if (this.timeout > 0) {
                jedis.expire(key, this.timeout);
            }
        }
    }

    public void create(Session session) {
        this.save(session);
    }

    public void delete(String id) {
        try (Jedis jedis = null;){
            jedis = this.pool.getResource();
            jedis.del(this.key(id));
        }
    }

    private String key(String id) {
        return this.prefix + ":" + id;
    }

    private String key(Session session) {
        return this.key(session.id());
    }

    private static int seconds(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            Config config = ConfigFactory.empty().withValue("timeout", ConfigValueFactory.fromAnyRef((Object)value));
            return (int)config.getDuration("timeout", TimeUnit.SECONDS);
        }
    }
}

