/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.jetty;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.util.Callback;
import org.jooby.Response;
import org.jooby.servlet.ServletServletRequest;
import org.jooby.servlet.ServletServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyResponse
extends ServletServletResponse
implements Callback {
    private final Logger log = LoggerFactory.getLogger(Response.class);
    private ServletServletRequest nreq;

    public JettyResponse(ServletServletRequest nreq, HttpServletResponse rsp) {
        super(nreq.servletRequest(), rsp);
        this.nreq = nreq;
    }

    public void send(byte[] bytes) throws Exception {
        this.sender().sendContent(ByteBuffer.wrap(bytes));
    }

    public void send(ByteBuffer buffer) throws Exception {
        this.sender().sendContent(buffer);
    }

    public void send(InputStream stream) throws Exception {
        this.nreq.startAsync();
        this.sender().sendContent(Channels.newChannel(stream), (Callback)this);
    }

    public void send(FileChannel channel) throws Exception {
        int bufferSize = this.rsp.getBufferSize();
        if (channel.size() < (long)bufferSize) {
            this.sender().sendContent((ReadableByteChannel)channel);
        } else {
            this.nreq.startAsync();
            this.sender().sendContent((ReadableByteChannel)channel, (Callback)this);
        }
    }

    private HttpOutput sender() {
        return ((org.eclipse.jetty.server.Response)this.rsp).getHttpOutput();
    }

    public void succeeded() {
        this.end();
    }

    public void failed(Throwable cause) {
        this.log.error("execution of " + this.nreq.path() + " resulted in exception", cause);
        this.end();
    }

    public void end() {
        super.end();
        this.nreq = null;
    }

    protected void close() {
        this.sender().close();
    }
}

