/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.jetty;

import com.google.common.base.Throwables;
import com.google.common.primitives.Primitives;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.net.ssl.SSLContext;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import org.jooby.internal.jetty.JettyHandler;
import org.jooby.internal.jetty.JettyWebSocket;
import org.jooby.spi.HttpHandler;
import org.jooby.spi.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServer
implements Server {
    private final Logger log = LoggerFactory.getLogger(Server.class);
    private org.eclipse.jetty.server.Server server;

    @Inject
    public JettyServer(HttpHandler handler, Config config, Provider<SSLContext> sslCtx) {
        this.server = this.server(handler, config, sslCtx);
    }

    private org.eclipse.jetty.server.Server server(HttpHandler handler, Config config, Provider<SSLContext> sslCtx) {
        System.setProperty("org.eclipse.jetty.util.UrlEncoded.charset", config.getString("jetty.url.charset"));
        System.setProperty("org.eclipse.jetty.server.Request.maxFormContentSize", config.getBytes("server.http.MaxRequestSize").toString());
        QueuedThreadPool pool = this.conf(new QueuedThreadPool(), config.getConfig("jetty.threads"), "jetty.threads");
        org.eclipse.jetty.server.Server server = new org.eclipse.jetty.server.Server((ThreadPool)pool);
        server.setStopAtShutdown(false);
        ServerConnector http = this.http(server, config.getConfig("jetty.http"), "jetty.http");
        http.setPort(config.getInt("application.port"));
        http.setHost(config.getString("application.host"));
        if (config.hasPath("application.securePort")) {
            ServerConnector https = this.https(server, config.getConfig("jetty.http"), "jetty.http", (SSLContext)sslCtx.get());
            https.setPort(config.getInt("application.securePort"));
            server.addConnector((Connector)https);
        }
        server.addConnector((Connector)http);
        WebSocketPolicy wsConfig = this.conf(new WebSocketPolicy(WebSocketBehavior.SERVER), config.getConfig("jetty.ws"), "jetty.ws");
        WebSocketServerFactory webSocketServerFactory = new WebSocketServerFactory(wsConfig);
        webSocketServerFactory.setCreator((req, rsp) -> {
            JettyWebSocket ws = new JettyWebSocket();
            req.getHttpServletRequest().setAttribute(JettyWebSocket.class.getName(), (Object)ws);
            return ws;
        });
        server.setHandler((Handler)new JettyHandler(handler, webSocketServerFactory, config.getString("application.tmpdir")));
        return server;
    }

    private ServerConnector http(org.eclipse.jetty.server.Server server, Config conf, String path) {
        HttpConfiguration httpConfig = this.conf(new HttpConfiguration(), conf.withoutPath("connector"), path);
        HttpConnectionFactory httpFactory = new HttpConnectionFactory(httpConfig);
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{httpFactory});
        return this.conf(connector, conf.getConfig("connector"), path + ".connector");
    }

    private ServerConnector https(org.eclipse.jetty.server.Server server, Config conf, String path, SSLContext sslContext) {
        HttpConfiguration httpConf = this.conf(new HttpConfiguration(), conf.withoutPath("connector"), path);
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setSslContext(sslContext);
        HttpConfiguration httpsConf = new HttpConfiguration(httpConf);
        httpsConf.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        HttpConnectionFactory httpsFactory = new HttpConnectionFactory(httpsConf);
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "HTTP/1.1"), httpsFactory});
        return this.conf(connector, conf.getConfig("connector"), path + ".connector");
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void join() throws InterruptedException {
        this.server.join();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    private void tryOption(Object source, Config config, Method option) {
        try {
            String optionName = option.getName().replace("set", "");
            Object optionValue = config.getAnyRef(optionName);
            Class optionType = Primitives.wrap(option.getParameterTypes()[0]);
            if (Number.class.isAssignableFrom(optionType) && optionValue instanceof String) {
                try {
                    optionValue = config.getBytes(optionName);
                }
                catch (ConfigException.BadValue ex) {
                    optionValue = config.getDuration(optionName, TimeUnit.MILLISECONDS);
                }
                if (optionType == Integer.class) {
                    optionValue = ((Number)optionValue).intValue();
                }
            }
            this.log.debug("{}.{}({})", new Object[]{source.getClass().getSimpleName(), option.getName(), optionValue});
            option.invoke(source, optionValue);
        }
        catch (Exception ex) {
            Throwable cause = ex;
            if (ex instanceof InvocationTargetException) {
                cause = ((InvocationTargetException)ex).getTargetException();
            }
            this.log.error("invocation of " + option + " resulted in exception", cause);
            throw Throwables.propagate((Throwable)cause);
        }
    }

    private <T> T conf(T source, Config config, String path) {
        Map methods = Arrays.stream(source.getClass().getMethods()).filter(m -> m.getName().startsWith("set") && m.getParameterCount() == 1).collect(Collectors.toMap(Method::getName, Function.identity()));
        config.entrySet().forEach(entry -> {
            String key = "set" + (String)entry.getKey();
            Method method = (Method)methods.get(key);
            if (method != null) {
                this.tryOption(source, config, method);
            } else {
                this.log.error("Unknown option: {}.{} for: {}", new Object[]{path, key, source.getClass().getName()});
            }
        });
        return source;
    }
}

