/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.jetty;

import java.io.IOException;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import org.jooby.MediaType;
import org.jooby.internal.jetty.JettyWebSocket;
import org.jooby.servlet.ServletServletRequest;
import org.jooby.servlet.ServletServletResponse;
import org.jooby.servlet.ServletUpgrade;
import org.jooby.spi.HttpHandler;
import org.jooby.spi.NativeRequest;
import org.jooby.spi.NativeResponse;
import org.jooby.spi.NativeWebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyHandler
extends AbstractHandler {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private HttpHandler dispatcher;
    private WebSocketServerFactory webSocketServerFactory;
    private String tmpdir;
    private MultipartConfigElement multiPartConfig;

    public JettyHandler(HttpHandler dispatcher, WebSocketServerFactory webSocketServerFactory, String tmpdir) {
        this.dispatcher = dispatcher;
        this.webSocketServerFactory = webSocketServerFactory;
        this.tmpdir = tmpdir;
        this.multiPartConfig = new MultipartConfigElement(tmpdir);
    }

    public void handle(String target, Request baseRequest, final HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException {
        try {
            baseRequest.setHandled(true);
            String type = baseRequest.getContentType();
            boolean multipart = false;
            if (type != null && type.toLowerCase().startsWith(MediaType.multipart.name())) {
                baseRequest.setAttribute("org.eclipse.jetty.multipartConfig", (Object)this.multiPartConfig);
                multipart = true;
            }
            this.dispatcher.handle((NativeRequest)new ServletServletRequest(request, this.tmpdir, multipart).with(new ServletUpgrade(){

                public <T> T upgrade(Class<T> type) throws Exception {
                    String key;
                    NativeWebSocket ws;
                    if (type == NativeWebSocket.class && JettyHandler.this.webSocketServerFactory.isUpgradeRequest(request, response) && JettyHandler.this.webSocketServerFactory.acceptWebSocket(request, response) && (ws = (NativeWebSocket)request.getAttribute(key = JettyWebSocket.class.getName())) != null) {
                        request.removeAttribute(key);
                        return (T)ws;
                    }
                    throw new UnsupportedOperationException("Not Supported: " + type);
                }
            }), (NativeResponse)new ServletServletResponse(request, response));
        }
        catch (IOException | RuntimeException | ServletException ex) {
            baseRequest.setHandled(false);
            this.log.error("execution of: " + target + " resulted in error", ex);
            throw ex;
        }
        catch (Throwable ex) {
            baseRequest.setHandled(false);
            this.log.error("execution of: " + target + " resulted in error", ex);
            throw new IllegalStateException(ex);
        }
    }
}

