/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.jetty;

import com.google.common.primitives.Primitives;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import org.jooby.internal.jetty.JettyHandler;
import org.jooby.internal.jetty.JettyWebSocket;
import org.jooby.spi.HttpHandler;
import org.jooby.spi.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServer
implements Server {
    private final Logger log = LoggerFactory.getLogger(Server.class);
    private org.eclipse.jetty.server.Server server;

    @Inject
    public JettyServer(HttpHandler handler, Config config) {
        this.server = this.server(handler, config);
    }

    private org.eclipse.jetty.server.Server server(HttpHandler handler, Config config) {
        System.setProperty("org.eclipse.jetty.util.UrlEncoded.charset", config.getString("jetty.url.charset"));
        System.setProperty("org.eclipse.jetty.server.Request.maxFormContentSize", config.getBytes("server.http.MaxRequestSize").toString());
        QueuedThreadPool pool = this.configure(new QueuedThreadPool(), config.getConfig("jetty.threads"), "jetty.threads");
        pool.setName("jetty");
        org.eclipse.jetty.server.Server server = new org.eclipse.jetty.server.Server((ThreadPool)pool);
        server.setStopAtShutdown(false);
        ServerConnector http = this.http(server, config.getConfig("jetty.http"), "jetty.http");
        http.setPort(config.getInt("application.port"));
        http.setHost(config.getString("application.host"));
        server.addConnector((Connector)http);
        WebSocketPolicy wsConfig = this.configure(new WebSocketPolicy(WebSocketBehavior.SERVER), config.getConfig("jetty.ws"), "jetty.ws");
        WebSocketServerFactory webSocketServerFactory = new WebSocketServerFactory(wsConfig);
        webSocketServerFactory.setCreator((req, rsp) -> {
            JettyWebSocket ws = new JettyWebSocket();
            req.getHttpServletRequest().setAttribute(JettyWebSocket.class.getName(), (Object)ws);
            return ws;
        });
        server.setHandler((Handler)new JettyHandler(handler, webSocketServerFactory, config.getString("application.tmpdir")));
        return server;
    }

    private ServerConnector http(org.eclipse.jetty.server.Server server, Config config, String path) {
        HttpConfiguration httpConfig = this.configure(new HttpConfiguration(), config.withoutPath("connector"), path);
        return this.configure(new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)}), config.getConfig("connector"), path + ".connector");
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void join() throws InterruptedException {
        this.server.join();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    private void tryOption(Object source, Config config, Method option) {
        String optionName = option.getName().replace("set", "");
        Object optionValue = config.getAnyRef(optionName);
        Class optionType = Primitives.wrap(option.getParameterTypes()[0]);
        if (Number.class.isAssignableFrom(optionType) && optionValue instanceof String) {
            try {
                optionValue = config.getBytes(optionName);
            }
            catch (ConfigException.BadValue ex) {
                optionValue = config.getDuration(optionName, TimeUnit.MILLISECONDS);
            }
            if (optionType == Integer.class) {
                optionValue = ((Number)optionValue).intValue();
            }
        }
        try {
            this.log.debug("{}.{}({})", new Object[]{source.getClass().getSimpleName(), option.getName(), optionValue});
            option.invoke(source, optionValue);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new IllegalStateException("Unknown/bad option: " + optionName, ex);
        }
    }

    private <T> T configure(T source, Config config, String path) {
        Map methods = Arrays.stream(source.getClass().getMethods()).filter(m -> m.getName().startsWith("set") && m.getParameterCount() == 1).collect(Collectors.toMap(Method::getName, Function.identity()));
        config.entrySet().forEach(entry -> {
            String key = "set" + (String)entry.getKey();
            Method method = (Method)methods.get(key);
            if (method != null) {
                this.tryOption(source, config, method);
            } else {
                this.log.error("Unknown option: {}.{} for: {}", new Object[]{path, key, source.getClass().getName()});
            }
        });
        return source;
    }
}

