/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.jetty;

import com.google.common.util.concurrent.MoreExecutors;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javaslang.concurrent.Promise;
import javaslang.control.Try;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.jooby.Sse;

public class JettySse
extends Sse {
    private Request req;
    private Response rsp;
    private HttpOutput out;

    public JettySse(Request request, Response rsp) {
        this.req = request;
        this.rsp = rsp;
        this.out = rsp.getHttpOutput();
    }

    protected void closeInternal() {
        Try.run(() -> this.rsp.closeOutput()).onFailure(cause -> this.log.debug("error while closing connection", cause));
    }

    protected void handshake(Runnable handler) throws Exception {
        this.req.getAsyncContext().setTimeout(0L);
        this.rsp.setStatus(200);
        this.rsp.setHeader("Connection", "Close");
        this.rsp.setContentType("text/event-stream; charset=utf-8");
        this.rsp.flushBuffer();
        HttpChannel channel = this.rsp.getHttpChannel();
        Connector connector = channel.getConnector();
        Executor executor = connector.getExecutor();
        executor.execute(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Promise<Optional<Object>> send(Optional<Object> id, byte[] data) {
        JettySse jettySse = this;
        synchronized (jettySse) {
            Promise promise = Promise.make((ExecutorService)MoreExecutors.newDirectExecutorService());
            try {
                this.out.write(data);
                this.out.flush();
                promise.success(id);
            }
            catch (Throwable ex) {
                promise.failure(ex);
                this.ifClose(ex);
            }
            return promise;
        }
    }

    protected boolean shouldClose(Throwable ex) {
        return ex instanceof EofException || super.shouldClose(ex);
    }
}

