/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.jetty;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javaslang.control.Try;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.SuspendToken;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.jooby.WebSocket;
import org.jooby.spi.NativeWebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocket
implements NativeWebSocket,
WebSocketListener {
    private static final String A_CALLBACK_IS_REQUIRED = "A callback is required.";
    private static final String NO_DATA_TO_SEND = "No data to send.";
    private final Logger log = LoggerFactory.getLogger(WebSocket.class);
    private Session session;
    private SuspendToken suspendToken;
    private Runnable onConnectCallback;
    private Consumer<String> onTextCallback;
    private Consumer<ByteBuffer> onBinaryCallback;
    private BiConsumer<Integer, Optional<String>> onCloseCallback;
    private Consumer<Throwable> onErrorCallback;

    public void close(int status, String reason) {
        this.session.close(status, reason);
    }

    public void resume() {
        if (this.suspendToken != null) {
            this.suspendToken.resume();
            this.suspendToken = null;
        }
    }

    public void onConnect(Runnable callback) {
        this.onConnectCallback = Objects.requireNonNull(callback, A_CALLBACK_IS_REQUIRED);
    }

    public void onTextMessage(Consumer<String> callback) {
        this.onTextCallback = Objects.requireNonNull(callback, A_CALLBACK_IS_REQUIRED);
    }

    public void onBinaryMessage(Consumer<ByteBuffer> callback) {
        this.onBinaryCallback = Objects.requireNonNull(callback, A_CALLBACK_IS_REQUIRED);
    }

    public void onCloseMessage(BiConsumer<Integer, Optional<String>> callback) {
        this.onCloseCallback = Objects.requireNonNull(callback, A_CALLBACK_IS_REQUIRED);
    }

    public void onErrorMessage(Consumer<Throwable> callback) {
        this.onErrorCallback = Objects.requireNonNull(callback, A_CALLBACK_IS_REQUIRED);
    }

    public void pause() {
        if (this.suspendToken == null) {
            this.suspendToken = this.session.suspend();
        }
    }

    public void terminate() throws IOException {
        this.session.disconnect();
    }

    public void sendBytes(ByteBuffer data, WebSocket.SuccessCallback success, WebSocket.ErrCallback err) {
        Objects.requireNonNull(data, NO_DATA_TO_SEND);
        RemoteEndpoint remote = this.session.getRemote();
        remote.sendBytes(data, JettyWebSocket.callback(this.log, success, err));
    }

    public void sendBytes(byte[] data, WebSocket.SuccessCallback success, WebSocket.ErrCallback err) {
        Objects.requireNonNull(data, NO_DATA_TO_SEND);
        this.sendBytes(ByteBuffer.wrap(data), success, err);
    }

    public void sendText(String data, WebSocket.SuccessCallback success, WebSocket.ErrCallback err) {
        Objects.requireNonNull(data, NO_DATA_TO_SEND);
        RemoteEndpoint remote = this.session.getRemote();
        remote.sendString(data, JettyWebSocket.callback(this.log, success, err));
    }

    public void sendText(byte[] data, WebSocket.SuccessCallback success, WebSocket.ErrCallback err) {
        Objects.requireNonNull(data, NO_DATA_TO_SEND);
        RemoteEndpoint remote = this.session.getRemote();
        remote.sendString(new String(data, StandardCharsets.UTF_8), JettyWebSocket.callback(this.log, success, err));
    }

    public void sendText(ByteBuffer data, WebSocket.SuccessCallback success, WebSocket.ErrCallback err) {
        Objects.requireNonNull(data, NO_DATA_TO_SEND);
        RemoteEndpoint remote = this.session.getRemote();
        CharBuffer buffer = StandardCharsets.UTF_8.decode(data);
        remote.sendString(buffer.toString(), JettyWebSocket.callback(this.log, success, err));
    }

    public boolean isOpen() {
        return this.session.isOpen();
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        this.onBinaryCallback.accept(ByteBuffer.wrap(payload, offset, len));
    }

    public void onWebSocketText(String message) {
        this.onTextCallback.accept(message);
    }

    public void onWebSocketClose(int statusCode, String reason) {
        this.onCloseCallback.accept(statusCode, Optional.ofNullable(reason));
    }

    public void onWebSocketConnect(Session session) {
        this.session = session;
        this.onConnectCallback.run();
    }

    public void onWebSocketError(Throwable cause) {
        this.onErrorCallback.accept(cause);
    }

    static WriteCallback callback(final Logger log, final WebSocket.SuccessCallback success, final WebSocket.ErrCallback err) {
        Objects.requireNonNull(success, "Success callback is required.");
        Objects.requireNonNull(err, "Error callback is required.");
        WriteCallback callback = new WriteCallback(){

            public void writeSuccess() {
                Try.run(() -> ((WebSocket.SuccessCallback)success).invoke()).onFailure(cause -> log.error("Error while invoking success callback", cause));
            }

            public void writeFailed(Throwable cause) {
                Try.run(() -> err.invoke(cause)).onFailure(ex -> log.error("Error while invoking err callback", ex));
            }
        };
        return callback;
    }
}

