/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.jetty;

import com.google.common.primitives.Primitives;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.net.ssl.SSLContext;
import javax.servlet.ServletContext;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import org.jooby.funzy.Try;
import org.jooby.internal.jetty.JettyHandler;
import org.jooby.internal.jetty.JettyWebSocket;
import org.jooby.spi.HttpHandler;
import org.jooby.spi.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServer
implements Server {
    private static final String H2 = "h2";
    private static final String H2_17 = "h2-17";
    private static final String HTTP_1_1 = "http/1.1";
    private static final String JETTY_HTTP = "jetty.http";
    private static final String CONNECTOR = "connector";
    private final Logger log = LoggerFactory.getLogger(Server.class);
    private org.eclipse.jetty.server.Server server;

    @Inject
    public JettyServer(HttpHandler handler, Config conf, Provider<SSLContext> sslCtx) {
        this.server = this.server(handler, conf, sslCtx);
    }

    private org.eclipse.jetty.server.Server server(HttpHandler handler, Config conf, Provider<SSLContext> sslCtx) {
        System.setProperty("org.eclipse.jetty.util.UrlEncoded.charset", conf.getString("jetty.url.charset"));
        System.setProperty("org.eclipse.jetty.server.Request.maxFormContentSize", conf.getBytes("server.http.MaxRequestSize").toString());
        QueuedThreadPool pool = this.conf(new QueuedThreadPool(), conf.getConfig("jetty.threads"), "jetty.threads");
        org.eclipse.jetty.server.Server server = new org.eclipse.jetty.server.Server((ThreadPool)pool);
        server.setStopAtShutdown(false);
        boolean http2 = conf.getBoolean("server.http2.enabled");
        ServerConnector http = this.http(server, conf.getConfig(JETTY_HTTP), JETTY_HTTP, http2);
        http.setPort(conf.getInt("application.port"));
        http.setHost(conf.getString("application.host"));
        if (conf.hasPath("application.securePort")) {
            ServerConnector https = this.https(server, conf.getConfig(JETTY_HTTP), JETTY_HTTP, (SSLContext)sslCtx.get(), http2);
            https.setPort(conf.getInt("application.securePort"));
            server.addConnector((Connector)https);
        }
        server.addConnector((Connector)http);
        ContextHandler sch = new ContextHandler();
        sch.setAttribute(DecoratedObjectFactory.ATTR, (Object)new DecoratedObjectFactory());
        WebSocketPolicy wsConfig = this.conf(new WebSocketPolicy(WebSocketBehavior.SERVER), conf.getConfig("jetty.ws"), "jetty.ws");
        WebSocketServerFactory webSocketServerFactory = new WebSocketServerFactory((ServletContext)sch.getServletContext(), wsConfig);
        webSocketServerFactory.setCreator((req, rsp) -> {
            JettyWebSocket ws = new JettyWebSocket();
            req.getHttpServletRequest().setAttribute(JettyWebSocket.class.getName(), (Object)ws);
            return ws;
        });
        sch.setContextPath("/");
        sch.setHandler((Handler)new JettyHandler(handler, webSocketServerFactory, conf.getString("application.tmpdir"), conf.getBytes("jetty.FileSizeThreshold").intValue()));
        server.setHandler((Handler)sch);
        return server;
    }

    private ServerConnector http(org.eclipse.jetty.server.Server server, Config conf, String path, boolean http2) {
        HttpConfiguration httpConfig = this.conf(new HttpConfiguration(), conf.withoutPath(CONNECTOR), path);
        ServerConnector connector = http2 ? new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig), new HTTP2CServerConnectionFactory(httpConfig)}) : new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
        return this.conf(connector, conf.getConfig(CONNECTOR), path + "." + CONNECTOR);
    }

    private ServerConnector https(org.eclipse.jetty.server.Server server, Config conf, String path, SSLContext sslContext, boolean http2) {
        HttpConfiguration httpConf = this.conf(new HttpConfiguration(), conf.withoutPath(CONNECTOR), path);
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setSslContext(sslContext);
        sslContextFactory.setIncludeProtocols(new String[]{"TLSv1.2"});
        sslContextFactory.setIncludeCipherSuites(new String[]{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"});
        sslContextFactory.setEndpointIdentificationAlgorithm("HTTPS");
        HttpConfiguration httpsConf = new HttpConfiguration(httpConf);
        httpsConf.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        HttpConnectionFactory https11 = new HttpConnectionFactory(httpsConf);
        if (http2) {
            ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[]{H2, H2_17, HTTP_1_1});
            alpn.setDefaultProtocol(HTTP_1_1);
            HTTP2ServerConnectionFactory https2 = new HTTP2ServerConnectionFactory(httpsConf);
            ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "alpn"), alpn, https2, https11});
            return this.conf(connector, conf.getConfig(CONNECTOR), path + ".connector");
        }
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HTTP_1_1), https11});
        return this.conf(connector, conf.getConfig(CONNECTOR), path + ".connector");
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void join() throws InterruptedException {
        this.server.join();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public Optional<Executor> executor() {
        return Optional.ofNullable(this.server.getThreadPool());
    }

    private void tryOption(Object source, Config config, Method option) {
        Try.run(() -> {
            String optionName = option.getName().replace("set", "");
            Object optionValue = config.getAnyRef(optionName);
            Class optionType = Primitives.wrap(option.getParameterTypes()[0]);
            if (Number.class.isAssignableFrom(optionType) && optionValue instanceof String) {
                try {
                    optionValue = config.getBytes(optionName);
                }
                catch (ConfigException.BadValue ex) {
                    optionValue = config.getDuration(optionName, TimeUnit.MILLISECONDS);
                }
                if (optionType == Integer.class) {
                    optionValue = ((Number)optionValue).intValue();
                }
            }
            this.log.debug("{}.{}({})", new Object[]{source.getClass().getSimpleName(), option.getName(), optionValue});
            option.invoke(source, optionValue);
        }).unwrap(InvocationTargetException.class).throwException();
    }

    private <T> T conf(T source, Config config, String path) {
        Map methods = Arrays.stream(source.getClass().getMethods()).filter(m -> m.getName().startsWith("set") && m.getParameterCount() == 1).collect(Collectors.toMap(Method::getName, Function.identity()));
        config.entrySet().forEach(entry -> {
            String key = "set" + (String)entry.getKey();
            Method method = (Method)methods.get(key);
            if (method != null) {
                this.tryOption(source, config, method);
            } else {
                this.log.error("Unknown option: {}.{} for: {}", new Object[]{path, key, source.getClass().getName()});
            }
        });
        return source;
    }
}

