/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.jetty;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.jooby.Sse;
import org.jooby.funzy.Try;

public class JettySse
extends Sse {
    private Request req;
    private Response rsp;
    private HttpOutput out;

    public JettySse(Request request, Response rsp) {
        this.req = request;
        this.rsp = rsp;
        this.out = rsp.getHttpOutput();
    }

    protected void closeInternal() {
        Try.run(() -> this.rsp.closeOutput()).onFailure(cause -> this.log.debug("error while closing connection", cause));
    }

    protected void handshake(Runnable handler) throws Exception {
        this.req.getAsyncContext().setTimeout(0L);
        this.rsp.setStatus(200);
        this.rsp.setHeader("Connection", "Close");
        this.rsp.setContentType("text/event-stream; charset=utf-8");
        this.rsp.flushBuffer();
        HttpChannel channel = this.rsp.getHttpChannel();
        Connector connector = channel.getConnector();
        Executor executor = connector.getExecutor();
        executor.execute(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Optional<Object>> send(Optional<Object> id, byte[] data) {
        JettySse jettySse = this;
        synchronized (jettySse) {
            CompletableFuture<Optional<Object>> future = new CompletableFuture<Optional<Object>>();
            try {
                this.out.write(data);
                this.out.flush();
                future.complete(id);
            }
            catch (Throwable ex) {
                future.completeExceptionally(ex);
                this.ifClose(ex);
            }
            return future;
        }
    }

    protected boolean shouldClose(Throwable ex) {
        return ex instanceof EofException || super.shouldClose(ex);
    }
}

