/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.less;

import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.core.DefaultLessCompiler;
import com.google.inject.Binder;
import com.google.inject.multibindings.Multibinder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.Objects;
import java.util.function.Consumer;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.Route;
import org.jooby.internal.less.ForwardingLessCompiler;
import org.jooby.internal.less.LessHandler;

public class Less
implements Jooby.Module {
    private String pattern;
    private String location;
    private Consumer<LessCompiler.Configuration> configurer;

    public Less(String pattern, String location) {
        this.pattern = Objects.requireNonNull(pattern, "Pattern is required.");
        this.location = Objects.requireNonNull(location, "Location pattern is required.");
    }

    public Less(String pattern) {
        this(pattern, "/");
    }

    public void configure(Env env, Config conf, Binder binder) {
        LessCompiler.Configuration options = this.options(env.name().equals("dev"), conf.getConfig("less"));
        if (this.configurer != null) {
            this.configurer.accept(options);
        }
        ForwardingLessCompiler compiler = new ForwardingLessCompiler((LessCompiler)new DefaultLessCompiler(), options);
        binder.bind(LessCompiler.class).toInstance((Object)compiler);
        LessHandler handler = new LessHandler(this.location, compiler);
        handler.cdn(conf.getString("assets.cdn"));
        handler.etag(conf.getBoolean("assets.etag"));
        Multibinder.newSetBinder((Binder)binder, Route.Definition.class).addBinding().toInstance((Object)new Route.Definition("GET", this.pattern, (Route.Filter)handler));
    }

    public Less doWith(Consumer<LessCompiler.Configuration> configurer) {
        this.configurer = Objects.requireNonNull(configurer, "Configurer callback is required.");
        return this;
    }

    public Config config() {
        return ConfigFactory.parseResources(this.getClass(), (String)"less.conf");
    }

    private LessCompiler.Configuration options(boolean dev, Config conf) {
        LessCompiler.Configuration configuration = new LessCompiler.Configuration();
        boolean compressing = conf.hasPath("compressing") ? conf.getBoolean("compressing") : !dev;
        configuration.setCompressing(compressing);
        LessCompiler.SourceMapConfiguration sourceMap = configuration.getSourceMapConfiguration();
        sourceMap.setEncodingCharset(conf.getString("sourceMap.encodingCharset"));
        sourceMap.setIncludeSourcesContent(conf.getBoolean("sourceMap.includeSourcesContent"));
        sourceMap.setInline(conf.getBoolean("sourceMap.inline"));
        sourceMap.setRelativizePaths(conf.getBoolean("sourceMap.relativizePaths"));
        boolean linkSourceMap = conf.hasPath("sourceMap.linkSourceMap") ? conf.getBoolean("sourceMap.linkSourceMap") : dev;
        sourceMap.setLinkSourceMap(linkSourceMap);
        return configuration;
    }
}

