/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.less;

import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import java.net.URL;
import org.jooby.Asset;
import org.jooby.MediaType;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Results;
import org.jooby.handlers.AssetHandler;
import org.jooby.less.Less;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LessHandler
extends AssetHandler {
    private LessCompiler compiler;
    private final Logger log = LoggerFactory.getLogger(Less.class);

    public LessHandler(String location, LessCompiler compiler) {
        super(location);
        this.compiler = compiler;
    }

    protected URL resolve(String path) throws Exception {
        return super.resolve(path.replace(".css", ".less").replace(".map", ""));
    }

    protected void send(Request req, Response rsp, Asset asset) throws Exception {
        LessSource.URLSource src = new LessSource.URLSource(asset.resource(), req.charset().name());
        LessCompiler.CompilationResult result = this.compiler.compile((LessSource)src);
        result.getWarnings().forEach(warning -> this.log.warn(warning.toString()));
        if (req.path().endsWith(".map")) {
            rsp.type(MediaType.json).send(Results.ok((Object)result.getSourceMap()));
        } else {
            rsp.type(MediaType.css).send(Results.ok((Object)result.getCss()));
        }
    }
}

