/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import java.io.File;
import java.net.URLClassLoader;
import java.nio.file.Path;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jooby.Classpath;
import org.jooby.apitool.ApiParser;

@Mojo(name="apitool", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class ApiToolMojo
extends AbstractMojo {
    @Component
    private MavenProject mavenProject;
    @Parameter(property="main.class", defaultValue="${application.class}")
    protected String mainClass;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.mainClass == null) {
            throw new MojoExecutionException("main class not configured");
        }
        try (URLClassLoader loader = new Classpath(this.mavenProject).toClassLoader();){
            Path srcdir = new File(this.mavenProject.getBuild().getSourceDirectory()).toPath();
            Path bindir = new File(this.mavenProject.getBuild().getOutputDirectory()).toPath();
            this.getLog().debug((CharSequence)("Using classloader " + loader));
            this.getLog().debug((CharSequence)("    source: " + srcdir));
            this.getLog().debug((CharSequence)("    bin: " + bindir));
            Path output = new ApiParser(srcdir).with((ClassLoader)loader).export(bindir, this.mainClass);
            this.getLog().info((CharSequence)("API file: " + output));
        }
        catch (Exception x) {
            throw new MojoFailureException("ApiTool resulted in exception: ", (Throwable)x);
        }
    }
}

