/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import com.google.common.io.Files;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import me.tongfei.progressbar.ProgressBar;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jooby.JoobyRunner;
import org.jooby.assets.AssetClassLoader;
import org.jooby.assets.AssetCompiler;
import org.jooby.funzy.Throwing;

@Mojo(name="assets", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE)
@Execute(phase=LifecyclePhase.PREPARE_PACKAGE)
public class AssetMojo
extends AbstractMojo {
    @Component
    private MavenProject mavenProject;
    @Parameter(property="main.class", defaultValue="${application.class}")
    protected String mainClass;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File output;
    @Parameter(defaultValue="${project.build.directory}${file.separator}__public_")
    private File assemblyOutput;
    @Parameter(defaultValue="dist")
    private String env;
    @Parameter(defaultValue="365d")
    private String maxAge;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            System.setProperty("application.env", this.env);
            new JoobyRunner(this.mavenProject).run(this.mainClass, (app, conf) -> this.compile(app.getClass().getClassLoader(), (Config)conf));
        }
        catch (Throwable ex) {
            throw new MojoFailureException("Can't compile assets for " + this.mainClass, ex);
        }
    }

    private void compile(ClassLoader loader, Config conf) {
        try {
            this.output.mkdirs();
            this.getLog().debug((CharSequence)("claspath: " + loader));
            Config assetConf = ConfigFactory.parseResources((ClassLoader)loader, (String)"assets.conf").withFallback((ConfigMergeable)conf);
            this.getLog().debug((CharSequence)("assets.conf: " + assetConf.getConfig("assets")));
            ClassLoader assetLoader = AssetClassLoader.classLoader((ClassLoader)loader, (File)this.mavenProject.getBasedir());
            AssetCompiler compiler = new AssetCompiler(assetLoader, assetConf);
            AtomicReference pb = new AtomicReference();
            compiler.setProgressBar((progress, total) -> {
                if (pb.get() == null) {
                    pb.set(new ProgressBar("Compiling assets", (long)total.intValue()).start().stepTo((long)progress.intValue()));
                } else {
                    ((ProgressBar)pb.get()).step();
                }
            });
            long start = System.currentTimeMillis();
            Map fileset = compiler.build(this.env, this.output);
            ((ProgressBar)pb.get()).stop();
            StringBuilder dist = new StringBuilder();
            dist.append("assets.fileset {\n").append(fileset.entrySet().stream().map(e -> {
                String files = ((List)e.getValue()).stream().map(file -> this.output.toPath().relativize(file.toPath())).map(path -> "/" + path.toString().replace("\\", "/")).collect(Collectors.joining("\", \"", "[\"", "\"]"));
                return "  " + (String)e.getKey() + ": " + files;
            }).collect(Collectors.joining("\n"))).append("\n}\n");
            dist.append("assets.cache.maxAge = ").append(this.maxAge).append("\n");
            dist.append("assets.watch = false\n");
            dist.append("assets.pipeline.dev = {}\n");
            dist.append("assets.pipeline.").append(this.env).append(" = {}\n");
            File distFile = new File(this.output, "assets." + this.env + ".conf");
            try (FileWriter writer = new FileWriter(distFile);){
                writer.write(dist.toString());
            }
            long end = System.currentTimeMillis();
            String summary = compiler.summary(fileset, this.output.toPath(), this.env, end - start, new String[]{"        " + this.assemblyOutput, "Assets: " + distFile});
            this.getLog().info((CharSequence)summary);
            List files = fileset.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            for (File from : files) {
                File to = this.assemblyOutput.toPath().resolve(this.output.toPath().relativize(from.toPath())).toFile();
                to.getParentFile().mkdirs();
                this.getLog().debug((CharSequence)("copying file to: " + to));
                Files.copy((File)from, (File)to);
            }
            compiler.stop();
        }
        catch (InvocationTargetException ex) {
            throw Throwing.sneakyThrow((Throwable)ex.getCause());
        }
        catch (Exception ex) {
            throw Throwing.sneakyThrow((Throwable)ex);
        }
    }
}

