/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;

public class Classpath {
    private MavenProject project;

    public Classpath(MavenProject project) {
        this.project = project;
    }

    public List<URL> build() throws MalformedURLException {
        ArrayList<URL> cp = new ArrayList<URL>();
        cp.addAll(this.resources(this.project.getResources()));
        cp.add(new File(this.project.getBuild().getOutputDirectory()).toURI().toURL());
        cp.addAll(this.jars(this.project.getArtifacts()));
        return cp;
    }

    public URLClassLoader toClassLoader() throws MalformedURLException {
        return Classpath.toClassLoader(this.build(), this.getClass().getClassLoader());
    }

    private static URLClassLoader toClassLoader(final List<URL> cp, ClassLoader parent) {
        return new URLClassLoader(cp.toArray(new URL[cp.size()]), parent){

            public String toString() {
                return cp.toString();
            }
        };
    }

    private List<URL> jars(Iterable<Artifact> artifacts) throws MalformedURLException {
        ArrayList<URL> result = new ArrayList<URL>();
        for (Artifact artifact : artifacts) {
            if ("pom".equals(artifact.getType())) continue;
            result.add(artifact.getFile().toURI().toURL());
        }
        return result;
    }

    private List<URL> resources(Iterable<Resource> resources) throws MalformedURLException {
        ArrayList<URL> result = new ArrayList<URL>();
        for (Resource resource : resources) {
            File dir = new File(resource.getDirectory());
            if (!dir.exists()) continue;
            result.add(dir.toURI().toURL());
        }
        return result;
    }
}

