/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jooby.Command;
import org.jooby.ProcessOutput;

public class ExternalCommand
implements Command {
    private boolean wait = true;
    private String name;
    private List<String> args;
    private File workdir;
    private Object alias;
    private Process process;
    private ProcessOutput out;

    public ExternalCommand(String alias, String name, List<String> args) {
        this.alias = alias;
        this.name = name;
        this.args = new ArrayList<String>(args);
    }

    public ExternalCommand() {
    }

    @Override
    public File getWorkdir() {
        return this.workdir;
    }

    @Override
    public void setWorkdir(File workdir) {
        if (this.workdir == null) {
            this.workdir = workdir;
        }
    }

    public boolean isWait() {
        return this.wait;
    }

    public void setWait(boolean wait) {
        this.wait = wait;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> arguments) {
        this.args = arguments;
    }

    @Override
    public void stop() throws InterruptedException {
        if (this.process != null) {
            this.out.stopIt();
            this.process.destroy();
            this.process.waitFor();
            this.process = null;
            this.out = null;
        }
    }

    @Override
    public void execute() throws IOException, InterruptedException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.name);
        cmd.addAll(this.args);
        this.process = new ProcessBuilder(cmd).directory(this.workdir).redirectErrorStream(true).start();
        this.out = new ProcessOutput(this.process.getInputStream());
        this.out.start();
        if (this.wait) {
            this.process.waitFor();
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        if (this.alias == null) {
            str.append(this.name);
            for (String arg : this.args) {
                str.append(" ").append(arg);
            }
        } else {
            str.append(this.alias);
        }
        return str.toString();
    }

    public void set(String cmd) {
        String[] cmdline = cmd.split("\\s+");
        this.setName(cmdline[0].trim());
        ArrayList<String> args = new ArrayList<String>();
        for (int i = 1; i < cmdline.length; ++i) {
            args.add(cmdline[i].trim());
        }
        this.setArgs(args);
    }

    @Override
    public String debug() {
        StringBuilder str = new StringBuilder();
        str.append(this.name);
        for (String arg : this.args) {
            str.append(" ").append(arg);
        }
        return str.toString();
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }
}

