/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import edu.emory.mathcs.backport.java.util.Arrays;
import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.jooby.Command;
import org.jooby.run.Main;

public class RunApp
implements Command {
    private String mId;
    private String mainClass;
    private File[] cp;
    private CountDownLatch latch;
    private String includes;
    private String excludes;
    private List<File> watchDirs;

    public RunApp(String mId, String mainClass, Set<File> cp, String includes, String excludes, List<File> watchDirs) {
        this.mId = mId;
        this.mainClass = mainClass;
        this.cp = cp.toArray(new File[cp.size()]);
        this.includes = includes;
        this.excludes = excludes;
        this.watchDirs = watchDirs;
        this.latch = new CountDownLatch(1);
    }

    @Override
    public void stop() throws InterruptedException {
        this.latch.countDown();
    }

    @Override
    public void execute() throws Exception {
        Main launcher = new Main(this.mId, this.mainClass, this.watchDirs, this.cp);
        if (this.includes != null) {
            launcher.includes(this.includes);
        }
        if (this.excludes != null) {
            launcher.excludes(this.excludes);
        }
        launcher.run(new String[0]);
        this.latch.await();
    }

    @Override
    public File getWorkdir() {
        return new File(System.getProperty("user.dir"));
    }

    @Override
    public void setWorkdir(File workdir) {
    }

    @Override
    public String debug() {
        return this.mId + "; deps = " + Arrays.toString((Object[])this.cp);
    }

    public String toString() {
        return this.mainClass;
    }
}

