/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoFailureException;
import org.jooby.Command;
import org.jooby.ExternalCommand;
import org.jooby.run.Main;

public class RunForkedApp
implements Command {
    private File basedir;
    private ExternalCommand cmd;
    private String mainClass;

    public RunForkedApp(File basedir, String debug, List<String> vmArgs, Set<File> cp, String mId, String mainClass, Set<File> appcp, String includes, String excludes, String watchDirs) throws MojoFailureException {
        this.basedir = basedir;
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(this.vmArgs(debug, vmArgs));
        args.add("-cp");
        args.add(cp.stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator)));
        args.add(Main.class.getName());
        args.add(mId);
        args.add(mainClass);
        args.add(appcp.stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator, "deps=", "")).trim());
        if (includes != null) {
            args.add("includes=" + includes);
        }
        if (excludes != null) {
            args.add("excludes=" + excludes);
        }
        if (watchDirs != null) {
            args.add("watchDirs=" + watchDirs);
        }
        args.add("props=" + this.dumpSysProps(basedir.toPath().resolve("target").resolve("sys.properties")));
        this.cmd = new ExternalCommand(mainClass, "java", args);
        this.cmd.setWorkdir(basedir);
        this.mainClass = mainClass;
    }

    @Override
    public void stop() throws InterruptedException {
        this.cmd.stop();
    }

    @Override
    public void execute() throws Exception {
        this.cmd.execute();
    }

    private Path dumpSysProps(Path path) throws MojoFailureException {
        try {
            FileOutputStream output = new FileOutputStream(path.toFile());
            Properties properties = System.getProperties();
            properties.store(output, "system properties");
            return path;
        }
        catch (IOException ex) {
            throw new MojoFailureException("Can't dump system properties to: " + path, (Throwable)ex);
        }
    }

    @Override
    public File getWorkdir() {
        return this.cmd.getWorkdir();
    }

    @Override
    public void setWorkdir(File workdir) {
    }

    @Override
    public String debug() {
        return this.cmd.debug();
    }

    private List<String> vmArgs(String debug, List<String> vmArgs) {
        File[] logbackFiles;
        ArrayList<String> results = new ArrayList<String>();
        if (vmArgs != null) {
            results.addAll(vmArgs);
        }
        if (!"false".equals(debug)) {
            if ("true".equals(debug)) {
                results.add("-agentlib:jdwp=transport=dt_socket,address=8000,server=y,suspend=n");
            } else {
                try {
                    int port = Integer.parseInt(debug);
                    results.add("-agentlib:jdwp=transport=dt_socket,address=" + port + ",server=y,suspend=n");
                }
                catch (NumberFormatException ex) {
                    results.add(debug);
                }
            }
        }
        for (File logback : logbackFiles = new File[]{this.localFile("conf", "logback-test.xml"), this.localFile("conf", "logback.xml")}) {
            if (!logback.exists()) continue;
            results.add("-Dlogback.configurationFile=" + logback.getAbsolutePath());
            break;
        }
        return results;
    }

    private File localFile(String ... paths) {
        File result = this.basedir;
        for (String path : paths) {
            result = new File(result, path);
        }
        return result;
    }

    public String toString() {
        return this.mainClass;
    }
}

