/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.micrometer;

import com.google.common.base.Strings;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.Map;
import org.jooby.Route;

public class TimedSupport {
    private final String name;
    private final String description;
    private final String[] tags;
    private final boolean histogram;
    private final double[] percentiles;
    private final boolean longTask;

    private TimedSupport(String name, boolean longTask, String description, String[] tags, boolean histogram, double[] percentiles) {
        this.name = name;
        this.longTask = longTask;
        this.description = description;
        this.tags = tags;
        this.histogram = histogram;
        this.percentiles = percentiles;
    }

    public Sample start(MeterRegistry registry) {
        if (this.longTask) {
            LongTaskTimer.Sample sample = LongTaskTimer.builder((String)this.name).description(this.description).tags(this.tags).register(registry).start();
            return () -> sample.stop();
        }
        Timer.Sample sample = Timer.start((MeterRegistry)registry);
        Timer timer = Timer.builder((String)this.name).description(this.description).tags(this.tags).publishPercentileHistogram(Boolean.valueOf(this.histogram)).publishPercentiles(this.percentiles).register(registry);
        return () -> sample.stop(timer);
    }

    public static TimedSupport create(Route route) {
        Map attributes = route.attributes();
        String timed = (String)attributes.get("timed");
        if (timed != null) {
            String[] extraTags = (String[])attributes.get("timed.extraTags");
            boolean histogram = attributes.get("timed.histogram") == Boolean.TRUE;
            double[] percentiles = (double[])attributes.get("timed.percentiles");
            boolean longTask = attributes.get("timed.longTask") == Boolean.TRUE;
            String description = Strings.emptyToNull((String)((String)attributes.get("timed.description")));
            return new TimedSupport(timed, longTask, description, extraTags, histogram, percentiles);
        }
        return null;
    }

    public static interface Sample {
        public long stop();
    }
}

