/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.micrometer;

import com.google.inject.Binder;
import com.netflix.spectator.atlas.AtlasConfig;
import com.typesafe.config.Config;
import io.micrometer.atlas.AtlasMeterRegistry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.dropwizard.DropwizardConfig;
import io.micrometer.core.instrument.dropwizard.DropwizardMeterRegistry;
import io.micrometer.core.instrument.simple.SimpleConfig;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import io.micrometer.datadog.DatadogConfig;
import io.micrometer.datadog.DatadogMeterRegistry;
import io.micrometer.ganglia.GangliaConfig;
import io.micrometer.ganglia.GangliaMeterRegistry;
import io.micrometer.graphite.GraphiteConfig;
import io.micrometer.graphite.GraphiteMeterRegistry;
import io.micrometer.influx.InfluxConfig;
import io.micrometer.influx.InfluxMeterRegistry;
import io.micrometer.jmx.JmxConfig;
import io.micrometer.jmx.JmxMeterRegistry;
import io.micrometer.newrelic.NewRelicConfig;
import io.micrometer.newrelic.NewRelicMeterRegistry;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.micrometer.signalfx.SignalFxConfig;
import io.micrometer.signalfx.SignalFxMeterRegistry;
import io.micrometer.statsd.StatsdConfig;
import io.micrometer.statsd.StatsdMeterRegistry;
import io.micrometer.wavefront.WavefrontConfig;
import io.micrometer.wavefront.WavefrontMeterRegistry;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.jooby.Env;
import org.jooby.Jooby;

public class Micrometer
implements Jooby.Module {
    private BiConsumer<CompositeMeterRegistry, Config> configurer;
    private Function simple;
    private Function atlas;
    private Function datadog;
    private Function ganglia;
    private Function graphite;
    private Function influx;
    private Function jmx;
    private Function newrelic;
    private Function prometheus;
    private Function signalfx;
    private Function statsd;
    private Function wavefront;
    private Function dropwizard;

    public Micrometer doWith(@Nonnull BiConsumer<CompositeMeterRegistry, Config> configurer) {
        this.configurer = configurer;
        return this;
    }

    public Micrometer doWith(@Nonnull Consumer<CompositeMeterRegistry> configurer) {
        return this.doWith((CompositeMeterRegistry registry, Config conf) -> configurer.accept((CompositeMeterRegistry)registry));
    }

    public Micrometer simple(@Nonnull Function<SimpleConfig, SimpleMeterRegistry> provider) {
        this.simple = provider;
        return this;
    }

    public Micrometer atlas(@Nonnull Function<AtlasConfig, AtlasMeterRegistry> provider) {
        this.atlas = provider;
        return this;
    }

    public Micrometer datadog(@Nonnull Function<DatadogConfig, DatadogMeterRegistry> provider) {
        this.datadog = provider;
        return this;
    }

    public Micrometer dropwizard(@Nonnull Function<DropwizardConfig, DropwizardMeterRegistry> provider) {
        this.dropwizard = provider;
        return this;
    }

    public Micrometer ganglia(@Nonnull Function<GangliaConfig, GangliaMeterRegistry> provider) {
        this.ganglia = provider;
        return this;
    }

    public Micrometer graphite(@Nonnull Function<GraphiteConfig, GraphiteMeterRegistry> provider) {
        this.graphite = provider;
        return this;
    }

    public Micrometer influx(@Nonnull Function<InfluxConfig, InfluxMeterRegistry> provider) {
        this.influx = provider;
        return this;
    }

    public Micrometer jmx(@Nonnull Function<JmxConfig, JmxMeterRegistry> provider) {
        this.jmx = provider;
        return this;
    }

    public Micrometer newrelic(@Nonnull Function<NewRelicConfig, NewRelicMeterRegistry> provider) {
        this.newrelic = provider;
        return this;
    }

    public Micrometer prometheus(@Nonnull Function<PrometheusConfig, PrometheusMeterRegistry> provider) {
        this.prometheus = provider;
        return this;
    }

    public Micrometer statsd(@Nonnull Function<StatsdConfig, StatsdMeterRegistry> provider) {
        this.statsd = provider;
        return this;
    }

    public Micrometer signalfx(@Nonnull Function<SignalFxConfig, SignalFxMeterRegistry> provider) {
        this.signalfx = provider;
        return this;
    }

    public Micrometer wavefront(@Nonnull Function<WavefrontConfig, WavefrontMeterRegistry> provider) {
        this.wavefront = provider;
        return this;
    }

    public void configure(Env env, Config conf, Binder binder) {
        CompositeMeterRegistry registry = new CompositeMeterRegistry();
        if (this.configurer != null) {
            this.configurer.accept(registry, conf);
        }
        ArrayList<Object> registries = new ArrayList<Object>();
        if (this.simple != null) {
            registries.add((MeterRegistry)this.simple.apply(Micrometer.simple(conf)));
        }
        if (this.atlas != null) {
            registries.add((MeterRegistry)this.atlas.apply(Micrometer.atlas(conf)));
        }
        if (this.datadog != null) {
            registries.add((MeterRegistry)this.datadog.apply(Micrometer.datadog(conf)));
        }
        if (this.dropwizard != null) {
            registries.add((MeterRegistry)this.dropwizard.apply(Micrometer.dropwizard(conf)));
        }
        if (this.ganglia != null) {
            registries.add((MeterRegistry)this.ganglia.apply(Micrometer.ganglia(conf)));
        }
        if (this.graphite != null) {
            registries.add((MeterRegistry)this.graphite.apply(Micrometer.graphite(conf)));
        }
        if (this.influx != null) {
            registries.add((MeterRegistry)this.influx.apply(Micrometer.influx(conf)));
        }
        if (this.jmx != null) {
            registries.add((MeterRegistry)this.jmx.apply(Micrometer.jmx(conf)));
        }
        if (this.newrelic != null) {
            registries.add((MeterRegistry)this.newrelic.apply(Micrometer.newrelic(conf)));
        }
        if (this.prometheus != null) {
            registries.add((MeterRegistry)this.prometheus.apply(Micrometer.prometheus(conf)));
        }
        if (this.signalfx != null) {
            registries.add((MeterRegistry)this.signalfx.apply(Micrometer.signalfx(conf)));
        }
        if (this.statsd != null) {
            registries.add((MeterRegistry)this.statsd.apply(Micrometer.statsd(conf)));
        }
        if (this.wavefront != null) {
            registries.add((MeterRegistry)this.wavefront.apply(Micrometer.wavefront(conf)));
        }
        if (registries.size() + registry.getRegistries().size() == 0) {
            SimpleMeterRegistry r = new SimpleMeterRegistry(Micrometer.simple(conf), Clock.SYSTEM);
            registries.add(r);
        }
        registries.forEach(it -> {
            registry.add(it);
            Class<?> type = it.getClass();
            binder.bind(type).toInstance(it);
        });
        binder.bind(MeterRegistry.class).toInstance((Object)registry);
        binder.bind(CompositeMeterRegistry.class).toInstance((Object)registry);
        env.onStop(() -> ((CompositeMeterRegistry)registry).close());
    }

    static SimpleConfig simple(Config conf) {
        return key -> Micrometer.value(conf, "simple.", key);
    }

    static DropwizardConfig dropwizard(final Config conf) {
        return new DropwizardConfig(){

            public String prefix() {
                return "dropwizard";
            }

            public String get(String key) {
                return Micrometer.value(conf, "dropwizard.", key);
            }
        };
    }

    static AtlasConfig atlas(Config conf) {
        return key -> Micrometer.value(conf, "atlas.", key);
    }

    static DatadogConfig datadog(Config conf) {
        return key -> Micrometer.value(conf, "datadog.", key);
    }

    static GangliaConfig ganglia(Config conf) {
        return key -> Micrometer.value(conf, "ganglia.", key);
    }

    static GraphiteConfig graphite(Config conf) {
        return key -> Micrometer.value(conf, "graphite.", key);
    }

    static InfluxConfig influx(Config conf) {
        return key -> Micrometer.value(conf, "influx.", key);
    }

    static JmxConfig jmx(Config conf) {
        return key -> Micrometer.value(conf, "jmx.", key);
    }

    static NewRelicConfig newrelic(Config conf) {
        return key -> Micrometer.value(conf, "newrelic.", key);
    }

    static PrometheusConfig prometheus(Config conf) {
        return key -> Micrometer.value(conf, "prometheus.", key);
    }

    static SignalFxConfig signalfx(Config conf) {
        return key -> Micrometer.value(conf, "signalfx.", key);
    }

    static StatsdConfig statsd(Config conf) {
        return key -> Micrometer.value(conf, "statsd.", key);
    }

    static WavefrontConfig wavefront(Config conf) {
        return key -> Micrometer.value(conf, "wavefront.", key);
    }

    static String value(Config conf, String prefix, String key) {
        String path = key;
        if (!path.startsWith(prefix)) {
            path = prefix + path;
        }
        return conf.hasPath(path = "micrometer." + path) ? conf.getString(path) : null;
    }
}

