/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.mongodb;

import com.google.inject.Injector;
import com.mongodb.DBObject;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.mongodb.morphia.Morphia;
import org.mongodb.morphia.ObjectFactory;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.mapping.MapperOptions;

class GuiceObjectFactory
implements ObjectFactory {
    private Injector injector;
    private ObjectFactory delegate;

    @Inject
    public GuiceObjectFactory(Injector injector, Morphia morphia) {
        this.injector = Objects.requireNonNull(injector, "Injector is required.");
        MapperOptions options = morphia.getMapper().getOptions();
        this.delegate = options.getObjectFactory();
        options.setObjectFactory((ObjectFactory)this);
    }

    public <T> T createInstance(Class<T> clazz) {
        if (this.shouldInject(clazz)) {
            return (T)this.injector.getInstance(clazz);
        }
        return (T)this.delegate.createInstance(clazz);
    }

    public <T> T createInstance(Class<T> clazz, DBObject dbObj) {
        if (this.shouldInject(clazz)) {
            return (T)this.injector.getInstance(clazz);
        }
        return (T)this.delegate.createInstance(clazz, dbObj);
    }

    public Object createInstance(Mapper mapper, MappedField mf, DBObject dbObj) {
        Class clazz = mf.getType();
        if (this.shouldInject(clazz)) {
            return this.injector.getInstance(clazz);
        }
        return this.delegate.createInstance(mapper, mf, dbObj);
    }

    public Map<?, ?> createMap(MappedField mf) {
        return this.delegate.createMap(mf);
    }

    public List<?> createList(MappedField mf) {
        return this.delegate.createList(mf);
    }

    public Set<?> createSet(MappedField mf) {
        return this.delegate.createSet(mf);
    }

    private boolean shouldInject(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (constructor.getAnnotation(Inject.class) == null) continue;
            return true;
        }
        return false;
    }
}

