/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.mongodb;

import com.mongodb.DBObject;
import java.lang.reflect.Field;
import org.jooby.internal.mongodb.StoredId;
import org.jooby.mongodb.GeneratedValue;
import org.jooby.mongodb.IdGen;
import org.mongodb.morphia.AbstractEntityInterceptor;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.mapping.MappedClass;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;

public class AutoIncID
extends AbstractEntityInterceptor {
    private Datastore db;
    private IdGen gen;

    public AutoIncID(Datastore db, IdGen gen) {
        this.db = db;
        this.gen = gen;
    }

    public void prePersist(Object entity, DBObject dbObj, Mapper mapper) {
        MappedClass mclass = mapper.getMappedClass(entity);
        Field id = mclass.getIdField();
        if (id.getAnnotation(GeneratedValue.class) != null) {
            try {
                id.setAccessible(true);
                String collName = this.gen.value(mclass.getClazz());
                Query q = this.db.find(StoredId.class, "_id", (Object)collName);
                UpdateOperations uOps = this.db.createUpdateOperations(StoredId.class).inc("value");
                StoredId newId = (StoredId)this.db.findAndModify(q, uOps);
                if (newId == null) {
                    newId = new StoredId(collName);
                    this.db.save((Object)newId);
                }
                id.set(entity, newId.value);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Can't generate ID on " + mclass, ex);
            }
        }
    }
}

