/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.mongodb;

import com.google.inject.Binder;
import com.mongodb.MongoClient;
import com.typesafe.config.Config;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.inject.Provider;
import org.jooby.Env;
import org.jooby.mongodb.GuiceObjectFactory;
import org.jooby.mongodb.Mongodb;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Morphia;
import org.mongodb.morphia.mapping.Mapper;

public class Monphia
extends Mongodb {
    private BiConsumer<Morphia, Config> morphiaCbck;
    private Consumer<Datastore> callback;

    public Monphia(String db) {
        super(db);
    }

    public Monphia() {
    }

    public Monphia doWith(BiConsumer<Morphia, Config> callback) {
        this.morphiaCbck = Objects.requireNonNull(callback, "Mapper callback is required.");
        return this;
    }

    public Monphia doWith(Consumer<Datastore> callback) {
        this.callback = Objects.requireNonNull(callback, "Datastore callback is required.");
        return this;
    }

    public void configure(Env env, Config config, Binder binder) {
        this.configure(env, config, binder, (uri, client) -> {
            String db = uri.getDatabase();
            Mapper mapper = new Mapper();
            Morphia morphia = new Morphia(mapper);
            if (this.morphiaCbck != null) {
                this.morphiaCbck.accept(morphia, config);
            }
            Provider ds = () -> {
                Datastore datastore = morphia.createDatastore((MongoClient)client.get(), db);
                if (this.callback != null) {
                    this.callback.accept(datastore);
                }
                return datastore;
            };
            binder.bind(this.key(Morphia.class, db)).toInstance((Object)morphia);
            binder.bind(this.key(GuiceObjectFactory.class, db)).asEagerSingleton();
            binder.bind(this.key(Datastore.class, db)).toProvider(ds).asEagerSingleton();
        });
    }
}

