/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.pac4j;

import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.Session;
import org.jooby.internal.pac4j.AuthResponse;
import org.jooby.pac4j.Auth;
import org.jooby.pac4j.AuthStore;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.RequiresHttpAction;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthCallback
implements Route.Filter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private AuthStore store;
    private Clients clients;
    private String redirectTo;

    @Inject
    public AuthCallback(Clients clients, AuthStore store, @Named(value="auth.login.redirectTo") String redirectTo) {
        this.clients = Objects.requireNonNull(clients, "Clients are required.");
        this.store = Objects.requireNonNull(store, "Auth store is required.");
        this.redirectTo = Objects.requireNonNull(redirectTo, "RedirectTo is required.");
    }

    public void handle(Request req, Response rsp, Route.Chain chain) throws Exception {
        WebContext ctx = (WebContext)req.require(WebContext.class);
        List clientList = this.clients.findAllClients();
        Client client = clientList.size() == 1 ? (Client)clientList.get(0) : this.clients.findClient(ctx);
        this.log.debug("client : {}", (Object)client);
        try {
            Credentials credentials = client.getCredentials(ctx);
            this.log.debug("credentials : {}", (Object)credentials);
            UserProfile profile = client.getUserProfile(credentials, ctx);
            this.log.debug("profile : {}", (Object)profile);
            Session session = req.session();
            if (profile != null) {
                session.set(Auth.ID, profile.getId());
                this.store.set(profile);
            }
            String requestedUrl = req.get("pac4jRequestedUrl").orElseGet(() -> session.unset("pac4jRequestedUrl").toOptional().map(url -> url.equals("/") ? this.redirectTo : url).orElse(this.redirectTo));
            this.log.info("redirecting to: {}", (Object)requestedUrl);
            rsp.redirect(requestedUrl);
        }
        catch (RequiresHttpAction ex) {
            new AuthResponse(rsp).handle(client, ex);
        }
    }
}

