/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.pac4j;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Primitives;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jooby.Cookie;
import org.jooby.Err;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Session;
import org.jooby.Status;
import org.pac4j.core.context.Cookie;
import org.pac4j.core.context.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthContext
implements WebContext {
    private static final String PREFIX = "b64~";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Request req;
    private Response rsp;
    private Map<String, String[]> params;

    @Inject
    public AuthContext(Request req, Response rsp) {
        this.req = req;
        this.rsp = rsp;
        this.params = this.params(req);
    }

    public String getRequestParameter(String name) {
        String[] values = this.params.get(name);
        return values == null ? null : values[0];
    }

    public Map<String, String[]> getRequestParameters() {
        return this.params;
    }

    public String getRequestHeader(String name) {
        return this.req.header(name).value(null);
    }

    public void setSessionAttribute(String name, Object value) {
        Session session = this.req.session();
        if (value == null) {
            session.unset(name);
        } else {
            session.set(name, this.objToStr(value));
        }
    }

    public Object getSessionAttribute(String name) {
        Session session = this.req.session();
        return this.strToObject(session.get(name).value(null));
    }

    public String getRequestMethod() {
        return this.req.method();
    }

    public void writeResponseContent(String content) {
        try {
            this.rsp.send((Object)content);
        }
        catch (Exception ex) {
            throw new Err(Status.SERVER_ERROR, (Throwable)ex);
        }
    }

    public void setResponseStatus(int code) {
        this.rsp.status(code);
    }

    public void setResponseHeader(String name, String value) {
        this.rsp.header(name, (Object)value);
    }

    public String getServerName() {
        return this.req.hostname();
    }

    public int getServerPort() {
        return this.req.port();
    }

    public String getScheme() {
        return this.req.secure() ? "https" : "http";
    }

    public String getFullRequestURL() {
        return this.getScheme() + "://" + this.getServerName() + ":" + this.getServerPort() + this.req.path();
    }

    private Map<String, String[]> params(Request req) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        req.params().toMap().forEach((name, value) -> {
            try {
                List values = value.toList();
                result.put(name, (Object)values.toArray(new String[values.size()]));
            }
            catch (Err ignored) {
                this.log.debug("ignoring HTTP param: " + name, (Throwable)ignored);
            }
        });
        return result.build();
    }

    public String toString() {
        return this.req.toString();
    }

    public Object getRequestAttribute(String name) {
        Optional attr = this.req.get(name);
        return attr.orElse(null);
    }

    public void setRequestAttribute(String name, Object value) {
        this.req.set(name, value);
    }

    public Object getSessionIdentifier() {
        return this.req.session().id();
    }

    public String getRemoteAddr() {
        return this.req.ip();
    }

    public void setResponseCharacterEncoding(String encoding) {
    }

    public void setResponseContentType(String content) {
        this.rsp.type(content);
    }

    public Collection<Cookie> getRequestCookies() {
        return this.req.cookies().stream().map(c -> {
            Cookie cookie = new Cookie(c.name(), (String)c.value().orElse(null));
            c.domain().ifPresent(arg_0 -> ((Cookie)cookie).setDomain(arg_0));
            c.path().ifPresent(arg_0 -> ((Cookie)cookie).setPath(arg_0));
            cookie.setHttpOnly(c.httpOnly());
            cookie.setSecure(c.secure());
            return cookie;
        }).collect(Collectors.toList());
    }

    public void addResponseCookie(Cookie cookie) {
        Cookie.Definition c = new Cookie.Definition(cookie.getName(), cookie.getValue());
        Optional.ofNullable(cookie.getDomain()).ifPresent(arg_0 -> ((Cookie.Definition)c).domain(arg_0));
        Optional.ofNullable(cookie.getPath()).ifPresent(arg_0 -> ((Cookie.Definition)c).path(arg_0));
        c.httpOnly(cookie.isHttpOnly());
        c.maxAge(cookie.getMaxAge());
        c.secure(cookie.isSecure());
        this.rsp.cookie(c);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object strToObject(String value) {
        if (value == null) return value;
        if (!value.startsWith(PREFIX)) {
            return value;
        }
        byte[] bytes = BaseEncoding.base64().decode((CharSequence)value.substring(PREFIX.length()));
        try (ObjectInputStream stream = new ObjectInputStream(new ByteArrayInputStream(bytes));){
            Object object = stream.readObject();
            return object;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can't de-serialize value " + value, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String objToStr(Object value) {
        if (value instanceof CharSequence) return value.toString();
        if (Primitives.isWrapperType(value.getClass())) {
            return value.toString();
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (ObjectOutputStream stream = new ObjectOutputStream(bytes);){
            stream.writeObject(value);
            stream.flush();
            String string = PREFIX + BaseEncoding.base64().encode(bytes.toByteArray());
            return string;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can't serialize value " + value, ex);
        }
    }
}

