/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.pac4j;

import com.google.common.base.CaseFormat;
import java.util.List;
import java.util.Objects;
import org.jooby.Err;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.Status;
import org.jooby.internal.pac4j.AuthResponse;
import org.jooby.pac4j.Auth;
import org.jooby.pac4j.AuthStore;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.ClientFinder;
import org.pac4j.core.client.Clients;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.RequiresHttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthFilter
implements Route.Filter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Class<? extends Client<?, ?>> clientType;
    private String clientName;
    private Class<? extends UserProfile> profileType;

    public AuthFilter(Class<? extends Client<?, ?>> clientType, Class<? extends UserProfile> profileType) {
        this.clientType = Objects.requireNonNull(clientType, "ClientType is required.");
        this.clientName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, clientType.getSimpleName().replace("Client", ""));
        this.profileType = Objects.requireNonNull(profileType, "ProfileType is required.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handle(Request req, Response rsp, Route.Chain chain) throws Exception {
        UserProfile profile;
        WebContext ctx = (WebContext)req.require(WebContext.class);
        ClientFinder finder = (ClientFinder)req.require(ClientFinder.class);
        AuthStore store = (AuthStore)req.require(AuthStore.class);
        Clients clients = (Clients)req.require(Clients.class);
        Client client = this.find(finder, clients, ctx, this.clientType, this.clientName);
        boolean useSession = client instanceof IndirectClient;
        String profileId = this.profileID(useSession, req);
        UserProfile userProfile = profile = profileId == null ? null : (UserProfile)store.get(profileId).orElse(null);
        if (profile == null && client instanceof DirectClient) {
            this.log.debug("Performing authentication for client: {}", (Object)client);
            try {
                Credentials credentials = client.getCredentials(ctx);
                this.log.debug("credentials: {}", (Object)credentials);
                profile = client.getUserProfile(credentials, ctx);
                this.log.debug("profile: {}", (Object)profile);
                if (profile != null) {
                    store.set(profile);
                }
            }
            catch (RequiresHttpAction e) {
                throw new TechnicalException("Unexpected HTTP action", (Throwable)e);
            }
        }
        if (profile == null) {
            if (!useSession) throw new Err(Status.UNAUTHORIZED);
            try {
                String requestedUrl = ctx.getFullRequestURL();
                this.log.debug("requestedUrl: {}", (Object)requestedUrl);
                ctx.setSessionAttribute("pac4jRequestedUrl", (Object)requestedUrl);
                client.redirect(ctx, true);
                rsp.end();
                return;
            }
            catch (RequiresHttpAction ex) {
                new AuthResponse(rsp).handle(client, ex);
            }
            return;
        } else {
            this.log.debug("profile found: {}", (Object)profile);
            this.seed(req, this.profileType, profile);
            chain.next(req, rsp);
        }
    }

    private String profileID(boolean useSession, Request req) {
        return req.get(Auth.ID).orElseGet(() -> useSession ? req.session().get(Auth.ID).value(null) : null);
    }

    private Client find(ClientFinder finder, Clients clients, WebContext ctx, Class<? extends Client<?, ?>> clientType, String clientName) {
        List result = finder.find(clients, ctx, clientName);
        if (result.size() > 0) {
            return (Client)result.get(0);
        }
        return clients.findClient(clientType);
    }

    private void seed(Request req, Class type, Object profile) {
        while (type != Object.class) {
            req.set(type, profile);
            type = type.getSuperclass();
        }
    }
}

